/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.columnfinder;

import adams.data.weka.columnfinder.AbstractFilteredColumnFinder;
import adams.data.weka.columnfinder.TrainableColumnFinder;
import adams.data.weka.rowfinder.NullFinder;
import adams.data.weka.rowfinder.RowFinder;
import adams.data.weka.rowfinder.TrainableRowFinder;
import weka.core.Instance;
import weka.core.Instances;

public class RowFilteredColumnFinder
extends AbstractFilteredColumnFinder {
    private static final long serialVersionUID = -2963065019052042099L;
    protected RowFinder m_RowFinder;
    protected boolean m_ColumnFinderTrained;

    public String globalInfo() {
        return "Creates a subset of rows using the provided RowFinder first before finding the columns using the subset.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row-finder", "rowFinder", (Object)new NullFinder());
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
        this.reset();
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public String rowFinderTipText() {
        return "The row finder to use for generating the subset for the column finder.";
    }

    @Override
    protected boolean doTrainColumnFinder(Instances data) {
        boolean result = true;
        if (this.m_RowFinder instanceof TrainableRowFinder) {
            result = ((TrainableRowFinder)this.m_RowFinder).trainRowFinder(data);
        }
        this.m_ColumnFinderTrained = false;
        return result;
    }

    @Override
    protected int[] doFindColumns(Instances data) {
        int[] rows = this.m_RowFinder.findRows(data);
        Instances subset = new Instances(data, rows.length);
        for (int row : rows) {
            subset.add((Instance)data.instance(row).copy());
        }
        if (!this.m_ColumnFinderTrained) {
            this.m_ColumnFinderTrained = true;
            if (this.m_ColumnFinder instanceof TrainableColumnFinder) {
                this.m_ColumnFinderTrained = ((TrainableColumnFinder)this.m_ColumnFinder).trainColumnFinder(data);
            }
            if (!this.m_ColumnFinderTrained) {
                throw new IllegalStateException("Failed to train column finder on subset of rows!");
            }
        }
        int[] result = this.m_ColumnFinder.findColumns(subset);
        return result;
    }
}

