/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.rowfinder;

import adams.core.base.BaseInterval;
import adams.data.weka.WekaAttributeIndex;
import adams.data.weka.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;
import weka.core.Instance;
import weka.core.Instances;

public class ByNumericRange
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    protected WekaAttributeIndex m_AttributeIndex;
    protected BaseInterval[] m_Ranges;

    public String globalInfo() {
        return "Returns the indices of rows of columns which values fall inside the minimum and maximum.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new WekaAttributeIndex("last"));
        this.m_OptionManager.add("range", "ranges", (Object)new BaseInterval[]{new BaseInterval("(-Infinity;+Infinity)")});
    }

    public void setAttributeIndex(WekaAttributeIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public WekaAttributeIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setRanges(BaseInterval[] value) {
        this.m_Ranges = value;
        this.reset();
    }

    public BaseInterval[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The intervals to use for matching numeric values.";
    }

    @Override
    protected int[] doFindRows(Instances data) {
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setData(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        if (!data.attribute(index).isNumeric()) {
            throw new IllegalStateException("Column at index '" + this.m_AttributeIndex.getIndex() + "' is not numeric!");
        }
        block0: for (int i = 0; i < data.numInstances(); ++i) {
            Instance row = data.instance(i);
            if (row.isMissing(index)) continue;
            double value = row.value(index);
            for (int n = 0; n < this.m_Ranges.length; ++n) {
                if (!this.m_Ranges[n].isInside(value)) continue;
                result.add(i);
                continue block0;
            }
        }
        return result.toArray();
    }
}

