/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;
import weka.core.Instances;

public class WekaTrainTestSetContainer
extends AbstractContainer {
    private static final long serialVersionUID = 7650097276531433711L;
    public static final String VALUE_TRAIN = "Train";
    public static final String VALUE_TRAIN_ORIGINALINDICES = "Train original indices";
    public static final String VALUE_TEST = "Test";
    public static final String VALUE_TEST_ORIGINALINDICES = "Test original indices";
    public static final String VALUE_SEED = "Seed";
    public static final String VALUE_FOLD_NUMBER = "FoldNumber";
    public static final String VALUE_FOLD_COUNT = "FoldCount";

    public WekaTrainTestSetContainer() {
        this(null, null);
    }

    public WekaTrainTestSetContainer(Instances train, Instances test) {
        this(train, test, null);
    }

    public WekaTrainTestSetContainer(Instances train, Instances test, Long seed) {
        this(train, test, seed, null, null);
    }

    public WekaTrainTestSetContainer(Instances train, Instances test, Long seed, Integer foldNumber, Integer foldCount) {
        this(train, test, seed, foldNumber, foldCount, null, null);
    }

    public WekaTrainTestSetContainer(Instances train, Instances test, Long seed, Integer foldNumber, Integer foldCount, int[] trainOriginal, int[] testOriginal) {
        this.store(VALUE_TRAIN, train);
        this.store(VALUE_TEST, test);
        this.store(VALUE_SEED, seed);
        this.store(VALUE_FOLD_NUMBER, foldNumber);
        this.store(VALUE_FOLD_COUNT, foldCount);
        this.store(VALUE_TRAIN_ORIGINALINDICES, trainOriginal);
        this.store(VALUE_TEST_ORIGINALINDICES, testOriginal);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_TRAIN, "training set", Instances.class);
        this.addHelp(VALUE_TEST, "test set", Instances.class);
        this.addHelp(VALUE_SEED, "seed value", Long.class);
        this.addHelp(VALUE_FOLD_NUMBER, "current fold (1-based)", Integer.class);
        this.addHelp(VALUE_FOLD_COUNT, "total number of folds", Integer.class);
        this.addHelp(VALUE_TRAIN_ORIGINALINDICES, "original indices (0-based, train); array of " + Integer.TYPE.getName());
        this.addHelp(VALUE_TEST_ORIGINALINDICES, "original indices (0-based, test); array of " + Integer.TYPE.getName());
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_TRAIN);
        result.add(VALUE_TEST);
        result.add(VALUE_SEED);
        result.add(VALUE_FOLD_NUMBER);
        result.add(VALUE_FOLD_COUNT);
        result.add(VALUE_TRAIN_ORIGINALINDICES);
        result.add(VALUE_TEST_ORIGINALINDICES);
        return result.iterator();
    }

    public boolean isValid() {
        return (this.hasValue(VALUE_TRAIN) && this.hasValue(VALUE_TEST) && !this.hasValue(VALUE_SEED) && !this.hasValue(VALUE_FOLD_NUMBER) && !this.hasValue(VALUE_FOLD_COUNT)) | (this.hasValue(VALUE_TRAIN) && this.hasValue(VALUE_TEST) && this.hasValue(VALUE_SEED) && !this.hasValue(VALUE_FOLD_NUMBER) && !this.hasValue(VALUE_FOLD_COUNT)) | (this.hasValue(VALUE_TRAIN) && this.hasValue(VALUE_TEST) && this.hasValue(VALUE_SEED) && this.hasValue(VALUE_FOLD_NUMBER) && this.hasValue(VALUE_FOLD_COUNT));
    }
}

