/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractFileWriter;
import adams.gui.tools.wekamultiexperimenter.io.AbstractExperimentIO;
import adams.gui.tools.wekamultiexperimenter.io.DefaultAdamsExperimentIO;

public class WekaExperimentFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -1488720963594190156L;
    protected AbstractExperimentIO m_Handler;

    public String globalInfo() {
        return "Saves an experiment file.Supported file formats of current handler: " + Utils.flatten((Object[])this.m_Handler.getSupportedFileExtensions(false), (String)",");
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)this.getDefaultHandler());
    }

    public String outputFileTipText() {
        return "The file to write the experiment to.";
    }

    protected AbstractExperimentIO getDefaultHandler() {
        return new DefaultAdamsExperimentIO();
    }

    public void setHandler(AbstractExperimentIO value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractExperimentIO getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The I/O handler to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)"output: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"handler", (Object)((Object)this.m_Handler), (String)", handler: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{this.m_Handler.getExperimentClass()};
    }

    protected String doExecute() {
        String result = null;
        if (!this.m_Handler.save(this.m_InputToken.getPayload(), this.m_OutputFile.getAbsoluteFile())) {
            result = "Failed to write experiment to: " + this.m_OutputFile;
        }
        return result;
    }
}

