/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.WekaAttributeSelectionContainer;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Random;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.RankedOutputSearch;
import weka.core.Instances;

public class WekaAttributeSelection
extends AbstractTransformer
implements Randomizable {
    private static final long serialVersionUID = 4145361817914402084L;
    protected ASEvaluation m_Evaluator;
    protected ASSearch m_Search;
    protected int m_Folds;
    protected long m_Seed;

    public String globalInfo() {
        return "Performs attribute selection on the incoming data.\nIn case of input in form of a " + WekaTrainTestSetContainer.class + " object, the train and test sets stored in the container are being used.\nNB: In case of cross-validation no reduced or transformed data can get generated!";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("evaluator", "evaluator", (Object)new CfsSubsetEval());
        this.m_OptionManager.add("search", "search", (Object)new BestFirst());
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)-1, null);
    }

    public void setEvaluator(ASEvaluation value) {
        this.m_Evaluator = value;
        this.reset();
    }

    public ASEvaluation getEvaluator() {
        return this.m_Evaluator;
    }

    public String evaluatorTipText() {
        return "The evaluation method to use.";
    }

    public void setSearch(ASSearch value) {
        this.m_Search = value;
        this.reset();
    }

    public ASSearch getSearch() {
        return this.m_Search;
    }

    public String searchTipText() {
        return "The search method to use.";
    }

    public void setFolds(int value) {
        if (value >= -1) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getLogger().severe("Number of folds must be >= -1, provided: " + value);
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in the cross-validation; no cross-validation is performed if folds < 2.";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for cross-validation (used for randomization).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"evaluator", this.m_Evaluator.getClass(), (String)"eval: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"search", this.m_Search.getClass(), (String)", search: ");
        String variable = QuickInfoHelper.getVariable((OptionHandler)this, (String)"folds");
        if (variable != null || this.m_Folds >= 2) {
            result = result + ", folds: " + (variable == null ? Integer.valueOf(this.m_Folds) : variable);
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, WekaTrainTestSetContainer.class};
    }

    public Class[] generates() {
        return new Class[]{WekaAttributeSelectionContainer.class};
    }

    protected String doExecute() {
        String result;
        block32: {
            result = null;
            try {
                WekaAttributeSelectionContainer cont;
                Instances dataTest;
                Instances data;
                if (this.m_InputToken.getPayload() instanceof Instances) {
                    data = (Instances)this.m_InputToken.getPayload();
                    dataTest = null;
                } else {
                    data = (Instances)((WekaTrainTestSetContainer)((Object)this.m_InputToken.getPayload())).getValue("Train", Instances.class);
                    dataTest = (Instances)((WekaTrainTestSetContainer)((Object)this.m_InputToken.getPayload())).getValue("Test", Instances.class);
                }
                if (result != null) break block32;
                boolean crossValidate = this.m_Folds >= 2;
                AttributeSelection eval = new AttributeSelection();
                eval.setEvaluator(this.m_Evaluator);
                eval.setSearch(this.m_Search);
                eval.setFolds(this.m_Folds);
                eval.setSeed((int)this.m_Seed);
                eval.setXval(crossValidate);
                if (crossValidate) {
                    Random random = new Random(this.m_Seed);
                    data = new Instances(data);
                    data.randomize(random);
                    if (data.classIndex() > -1 && data.classAttribute().isNominal()) {
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Stratifying instances...");
                        }
                        data.stratify(this.m_Folds);
                    }
                    for (int fold = 0; fold < this.m_Folds; ++fold) {
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Creating splits for fold " + (fold + 1) + "...");
                        }
                        Instances train = data.trainCV(this.m_Folds, fold, random);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Selecting attributes using all but fold " + (fold + 1) + "...");
                        }
                        eval.selectAttributesCVSplit(train);
                    }
                } else {
                    eval.SelectAttributes(data);
                }
                Instances reduced = null;
                Instances reducedTest = null;
                Instances transformed = null;
                Instances transformedTest = null;
                if (!crossValidate) {
                    reduced = eval.reduceDimensionality(data);
                    if (this.m_Evaluator instanceof AttributeTransformer) {
                        transformed = ((AttributeTransformer)this.m_Evaluator).transformedData(data);
                    }
                    if (dataTest != null) {
                        reducedTest = eval.reduceDimensionality(dataTest);
                        if (this.m_Evaluator instanceof AttributeTransformer) {
                            transformedTest = ((AttributeTransformer)this.m_Evaluator).transformedData(dataTest);
                        }
                    }
                }
                DefaultSpreadSheet stats = null;
                if (!crossValidate) {
                    double[][] ranked;
                    int i;
                    stats = new DefaultSpreadSheet();
                    HeaderRow row = stats.getHeaderRow();
                    boolean useReduced = false;
                    if (this.m_Search instanceof RankedOutputSearch) {
                        i = reduced.numAttributes();
                        if (reduced.classIndex() > -1) {
                            --i;
                        }
                        boolean bl = useReduced = (ranked = eval.rankedAttributes()).length == i;
                    }
                    if (useReduced) {
                        for (i = 0; i < reduced.numAttributes(); ++i) {
                            row.addCell("" + i).setContent(reduced.attribute(i).name());
                        }
                        row = stats.addRow();
                        for (i = 0; i < reduced.numAttributes(); ++i) {
                            row.addCell(i).setContent(Double.valueOf(0.0));
                        }
                    } else {
                        for (i = 0; i < data.numAttributes(); ++i) {
                            row.addCell("" + i).setContent(data.attribute(i).name());
                        }
                        row = stats.addRow();
                        for (i = 0; i < data.numAttributes(); ++i) {
                            row.addCell(i).setContent(Double.valueOf(0.0));
                        }
                    }
                    if (this.m_Search instanceof RankedOutputSearch) {
                        ranked = eval.rankedAttributes();
                        for (i = 0; i < ranked.length; ++i) {
                            row.getCell((int)ranked[i][0]).setContent(Double.valueOf(ranked[i][1]));
                        }
                    } else {
                        int[] selected = eval.selectedAttributes();
                        for (i = 0; i < selected.length; ++i) {
                            row.getCell(selected[i]).setContent(Double.valueOf(1.0));
                        }
                    }
                }
                String rangeStr = null;
                if (!crossValidate) {
                    Range range = new Range();
                    range.setIndices(eval.selectedAttributes());
                    rangeStr = range.getRange();
                }
                if (crossValidate) {
                    cont = new WekaAttributeSelectionContainer(data, reduced, transformed, eval, this.m_Seed, this.m_Folds);
                } else {
                    cont = new WekaAttributeSelectionContainer(data, reduced, transformed, eval, (SpreadSheet)stats, rangeStr);
                    if (dataTest != null) {
                        cont.setValue("Test", dataTest);
                        cont.setValue("Test reduced", reducedTest);
                        cont.setValue("Test transformed", transformedTest);
                    }
                }
                this.m_OutputToken = new Token((Object)cont);
            }
            catch (Exception e) {
                this.m_OutputToken = null;
                result = this.handleException("Failed to process data:", e);
            }
        }
        return result;
    }
}

