/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.Stoppable;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.weka.InstancesViewCreator;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.DefaultCrossValidationFoldGenerator;
import weka.core.Instances;

public class WekaCrossValidationSplit
extends AbstractTransformer
implements Randomizable,
InstancesViewCreator {
    private static final long serialVersionUID = 4026105903223741240L;
    public static final String BACKUP_GENERATOR = "generator";
    protected long m_Seed;
    protected int m_Folds;
    protected String m_RelationName;
    protected boolean m_CreateView;
    protected CrossValidationFoldGenerator m_Generator;
    protected transient CrossValidationFoldGenerator m_ActualGenerator;

    public String globalInfo() {
        return "Generates train/test pairs like during a cross-validation run. It is possible to generate pairs for leave-one-out cross-validation (LOOCV) as well.\nIt is essential that a class attribute is set. In case of a nominal class attribute, the data gets stratified automatically.\nEach of the pairs gets forwarded as a container. The training set can be accessed in the container with 'Train' and the test set with 'Test'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("folds", "folds", (Object)10);
        this.m_OptionManager.add("relation", "relationName", (Object)"@");
        this.m_OptionManager.add("create-view", "createView", (Object)false);
        this.m_OptionManager.add(BACKUP_GENERATOR, BACKUP_GENERATOR, (Object)new DefaultCrossValidationFoldGenerator());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"folds", (Object)this.m_Folds, (String)"folds: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"relationName", (Object)this.m_RelationName, (String)", relation: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"createView", (boolean)this.m_CreateView, (String)", view only");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaTrainTestSetContainer.class};
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the randomization; overrides the value defined by the fold generator scheme.";
    }

    public void setFolds(int value) {
        if (value >= 2 || value == -1) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getLogger().severe("Folds must be >=2 or -1 for LOOCV (provided: " + value + ")!");
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in the cross-validation; use -1 for leave-one-out cross-validation (LOOCV); overrides the value defined by the fold generator scheme.";
    }

    public void setRelationName(String value) {
        this.m_RelationName = value;
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return "The placeholders for creating the relation name: @ = original relation name, $T = type (train/test), $N = current fold number; overrides the value defined by the fold generator scheme.";
    }

    @Override
    public void setCreateView(boolean value) {
        this.m_CreateView = value;
        this.reset();
    }

    @Override
    public boolean getCreateView() {
        return this.m_CreateView;
    }

    @Override
    public String createViewTipText() {
        return "If enabled, views of the dataset are created instead of actual copies; overrides the value defined by the fold generator scheme.";
    }

    public void setGenerator(CrossValidationFoldGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public CrossValidationFoldGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The scheme to use for generating the folds; the actor options take precedence over the scheme's ones.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_GENERATOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualGenerator != null) {
            result.put(BACKUP_GENERATOR, this.m_ActualGenerator);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_GENERATOR)) {
            this.m_ActualGenerator = (CrossValidationFoldGenerator)state.get(BACKUP_GENERATOR);
            state.remove(BACKUP_GENERATOR);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_ActualGenerator = null;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_ActualGenerator = (CrossValidationFoldGenerator)OptionUtils.shallowCopy((Object)this.m_Generator);
            this.m_ActualGenerator.setData((Instances)this.m_InputToken.getPayload());
            this.m_ActualGenerator.setNumFolds(this.m_Folds);
            this.m_ActualGenerator.setSeed(this.m_Seed);
            this.m_ActualGenerator.setStratify(true);
            this.m_ActualGenerator.setRandomize(true);
            this.m_ActualGenerator.setRelationName(this.m_RelationName);
            this.m_ActualGenerator.setUseViews(this.m_CreateView);
        }
        catch (Exception e) {
            result = this.handleException("Failed to initialize fold generator!", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_ActualGenerator != null && this.m_ActualGenerator.hasNext();
    }

    public Token output() {
        Token result = new Token((Object)this.m_ActualGenerator.next());
        return result;
    }

    public void wrapUp() {
        this.m_ActualGenerator = null;
        super.wrapUp();
    }

    public void stopExecution() {
        if (this.m_ActualGenerator != null && this.m_ActualGenerator instanceof Stoppable) {
            ((Stoppable)this.m_ActualGenerator).stopExecution();
        }
        super.stopExecution();
    }
}

