/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.wekaensemblegenerator.AbstractWekaEnsembleGenerator;
import adams.flow.transformer.wekaensemblegenerator.VotedModels;

public class WekaEnsembleGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 6016827763901994488L;
    protected AbstractWekaEnsembleGenerator m_Generator;

    public String globalInfo() {
        return "Uses the specified generator to create ensembles from the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new VotedModels());
    }

    public void setGenerator(AbstractWekaEnsembleGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractWekaEnsembleGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The ensemble generator to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator), (String)"generator: ");
    }

    public Class[] accepts() {
        return this.m_Generator.accepts();
    }

    public Class[] generates() {
        return this.m_Generator.generates();
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_OutputToken = new Token(this.m_Generator.generate(this.m_InputToken.getPayload()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate ensemble using: " + this.m_Generator.toCommandLine(), e);
        }
        return result;
    }
}

