/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaAssociatorContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.source.WekaAssociatorSetup;
import adams.flow.transformer.AbstractTransformer;
import weka.associations.AssociationRulesProducer;
import weka.associations.Associator;
import weka.core.Instances;

public class WekaTrainAssociator
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    protected CallableActorReference m_Associator;
    protected Associator m_ActualAssociator;

    public String globalInfo() {
        return "Trains a associator based on the incoming dataset and outputs the built associator alongside the training header and rules (in a model container)..";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("associator", "associator", (Object)new CallableActorReference(WekaAssociatorSetup.class.getSimpleName()));
    }

    public void setAssociator(CallableActorReference value) {
        this.m_Associator = value;
        this.reset();
    }

    public CallableActorReference getAssociator() {
        return this.m_Associator;
    }

    public String associatorTipText() {
        return "The Weka associator to train on the input data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"associator", (Object)this.m_Associator);
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaAssociatorContainer.class};
    }

    protected Associator getAssociatorInstance() throws Exception {
        MessageCollection errors = new MessageCollection();
        Associator result = (Associator)CallableActorHelper.getSetup(Associator.class, (CallableActorReference)this.m_Associator, (Actor)this, (MessageCollection)errors);
        if (result == null) {
            if (errors.isEmpty()) {
                throw new IllegalStateException("Failed to obtain associator from '" + this.m_Associator + "'!");
            }
            throw new IllegalStateException("Failed to obtain associator from '" + this.m_Associator + "':\n" + errors);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                Associator cls = this.getAssociatorInstance();
                Instances data = (Instances)this.m_InputToken.getPayload();
                cls.buildAssociations(data);
                this.m_OutputToken = cls instanceof AssociationRulesProducer && ((AssociationRulesProducer)cls).canProduceRules() ? new Token((Object)new WekaAssociatorContainer(cls, new Instances(data, 0), data, ((AssociationRulesProducer)cls).getAssociationRules().getRules())) : new Token((Object)new WekaAssociatorContainer(cls, new Instances(data, 0), data));
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        return result;
    }
}

