/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekadatasetsmerge;

import adams.flow.transformer.wekadatasetsmerge.AbstractMerge;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class JoinOnID
extends AbstractMerge {
    private static final long serialVersionUID = 5764925655464274742L;
    protected String m_UniqueID;
    protected boolean m_CompleteRowsOnly;

    public String globalInfo() {
        return "Joins the datasets by concatenating rows that share a unique ID.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("unique-id", "uniqueID", (Object)"");
        this.m_OptionManager.add("complete-rows-only", "completeRowsOnly", (Object)false);
    }

    public String getUniqueID() {
        return this.m_UniqueID;
    }

    public void setUniqueID(String value) {
        this.m_UniqueID = value;
        this.reset();
    }

    public String uniqueIDTipText() {
        return "The name of the attribute to use as the joining key for the merge.";
    }

    public boolean getCompleteRowsOnly() {
        return this.m_CompleteRowsOnly;
    }

    public void setCompleteRowsOnly(boolean value) {
        this.m_CompleteRowsOnly = value;
        this.reset();
    }

    public String completeRowsOnlyTipText() {
        return "Whether only those IDs that have source data in all datasets should be merged.";
    }

    protected String checkAllDatasetsHaveIDAttribute(Instances[] datasets) {
        Attribute checkAgainst = null;
        for (Instances dataset : datasets) {
            Attribute idAttribute = dataset.attribute(this.m_UniqueID);
            if (idAttribute == null) {
                return "Dataset " + dataset.relationName() + " does not have the ID attribute (" + this.m_UniqueID + ")";
            }
            if (checkAgainst == null) {
                checkAgainst = idAttribute;
                continue;
            }
            if (idAttribute.type() != checkAgainst.type()) {
                return "Dataset " + dataset.relationName() + "has a different type for it's ID attribute (" + Attribute.typeToString((int)idAttribute.type()) + " instead of " + Attribute.typeToString((int)checkAgainst.type()) + ")";
            }
            String message = checkAgainst.equalsMsg((Object)idAttribute);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    protected boolean isUniqueIDName(String attributeName) {
        return attributeName.equals(this.m_UniqueID);
    }

    protected int findAttributeIndexOfUniqueID(Instances dataset) {
        for (int attributeIndex = 0; attributeIndex < dataset.numAttributes(); ++attributeIndex) {
            Attribute attribute = dataset.attribute(attributeIndex);
            if (!this.isUniqueIDName(attribute.name())) continue;
            return attributeIndex;
        }
        return -1;
    }

    @Override
    protected int compare(List<AbstractMerge.SourceAttribute> sources1, List<AbstractMerge.SourceAttribute> sources2) {
        boolean idName1 = this.isUniqueIDName(sources1.get((int)0).attributeName);
        boolean idName2 = this.isUniqueIDName(sources2.get((int)0).attributeName);
        if (idName1 && !idName2) {
            return -1;
        }
        if (!idName1 && idName2) {
            return 1;
        }
        return super.compare(sources1, sources2);
    }

    @Override
    protected String getMappedAttributeName(AbstractMerge.SourceAttribute source) {
        if (this.isUniqueIDName(source.attributeName)) {
            return source.attributeName;
        }
        return super.getMappedAttributeName(source);
    }

    @Override
    protected Enumeration<int[]> getRowSetEnumeration() {
        return new UniqueIDEnumeration(this.m_Datasets);
    }

    @Override
    protected String check(Instances[] datasets) {
        String result = super.check(datasets);
        if (result != null) {
            return result;
        }
        return this.checkAllDatasetsHaveIDAttribute(datasets);
    }

    @Override
    protected String checkAttributeMapping(Map<String, List<AbstractMerge.SourceAttribute>> attributeMapping) {
        String result = super.checkAttributeMapping(attributeMapping);
        if (result != null) {
            return result;
        }
        if (this.isAnyClassAttribute(attributeMapping.get(this.m_UniqueID))) {
            result = "The provided unique ID (" + this.getUniqueID() + ") is also a class attribute.";
        }
        return result;
    }

    public class UniqueIDEnumeration
    implements Enumeration<int[]> {
        private Map<Object, int[]> m_UniqueIDRowMap;
        private Iterator<Object> m_InternalIterator;

        private UniqueIDEnumeration(Instances[] datasets) {
            this.recordUniqueIDs(datasets);
            this.m_InternalIterator = this.m_UniqueIDRowMap.keySet().iterator();
        }

        private void recordUniqueIDs(Instances[] datasetsToMerge) {
            this.m_UniqueIDRowMap = new LinkedHashMap<Object, int[]>();
            for (int datasetIndex = 0; datasetIndex < datasetsToMerge.length; ++datasetIndex) {
                Instances dataset = datasetsToMerge[datasetIndex];
                int uniqueIDAttributeIndex = JoinOnID.this.findAttributeIndexOfUniqueID(dataset);
                if (uniqueIDAttributeIndex == -1) continue;
                for (int instanceIndex = 0; instanceIndex < dataset.size(); ++instanceIndex) {
                    Instance instance = dataset.instance(instanceIndex);
                    Object id = JoinOnID.this.getValue(instance, uniqueIDAttributeIndex);
                    if (id == null) continue;
                    if (!this.m_UniqueIDRowMap.containsKey(id)) {
                        this.m_UniqueIDRowMap.put(id, this.initialiseRowSet(datasetsToMerge.length));
                    }
                    int[] rowInstanceTable = this.m_UniqueIDRowMap.get(id);
                    rowInstanceTable[datasetIndex] = instanceIndex;
                }
            }
            if (JoinOnID.this.getCompleteRowsOnly()) {
                this.removeIncompleteRows();
            }
        }

        private int[] initialiseRowSet(int size) {
            int[] rowSet = new int[size];
            for (int i = 0; i < size; ++i) {
                rowSet[i] = -1;
            }
            return rowSet;
        }

        private void removeIncompleteRows() {
            Iterator<Object> idIterator = this.m_UniqueIDRowMap.keySet().iterator();
            block0: while (idIterator.hasNext()) {
                int[] rowSet;
                Object id = idIterator.next();
                for (int rowEntry : rowSet = this.m_UniqueIDRowMap.get(id)) {
                    if (rowEntry != -1) continue;
                    idIterator.remove();
                    continue block0;
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_InternalIterator.hasNext();
        }

        @Override
        public int[] nextElement() {
            Object nextID = this.m_InternalIterator.next();
            return this.m_UniqueIDRowMap.get(nextID);
        }
    }
}

