/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekadatasetsmerge;

import adams.flow.transformer.wekadatasetsmerge.AbstractMerge;
import java.util.Enumeration;
import weka.core.Instances;

public class Simple
extends AbstractMerge {
    private static final long serialVersionUID = 6417253231850358108L;

    public String globalInfo() {
        return "Just merges the datasets side by side. Requires the datasets to have the same number of rows.";
    }

    @Override
    protected String check(Instances[] datasets) {
        String result = super.check(datasets);
        if (result == null) {
            for (int i = 1; i < datasets.length; ++i) {
                if (datasets[0].numInstances() == datasets[i].numInstances()) continue;
                return "Datasets #" + (i + 1) + "has " + datasets[i].numInstances() + " rows instead of " + datasets[0].numInstances();
            }
        }
        return result;
    }

    @Override
    protected Enumeration<int[]> getRowSetEnumeration() {
        return new SimpleRowSetIterator(this.m_Datasets);
    }

    public static class SimpleRowSetIterator
    implements Enumeration<int[]> {
        private int m_NextRow = 0;
        private int m_RowCount;
        private int m_DatasetCount;

        private SimpleRowSetIterator(Instances[] datasets) {
            this.m_RowCount = datasets[0].numInstances();
            this.m_DatasetCount = datasets.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_NextRow < this.m_RowCount;
        }

        @Override
        public int[] nextElement() {
            int[] nextElement = new int[this.m_DatasetCount];
            for (int i = 0; i < nextElement.length; ++i) {
                nextElement[i] = this.m_NextRow;
            }
            ++this.m_NextRow;
            return nextElement;
        }
    }
}

