/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaevaluationpostprocessor;

import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import gnu.trove.list.TIntList;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractWekaEvaluationPostProcessor
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -1975307519142567955L;

    public String getQuickInfo() {
        return null;
    }

    protected String check(WekaEvaluationContainer cont) {
        if (cont == null) {
            return "No evaluation container provided!";
        }
        if (!cont.hasValue("Evaluation")) {
            return "No Evaluation object in container present!";
        }
        return this.check((Evaluation)cont.getValue("Evaluation"));
    }

    protected WekaEvaluationContainer newContainer(String suffix, WekaEvaluationContainer cont, TIntList indices) {
        Evaluation eval = (Evaluation)cont.getValue("Evaluation");
        Evaluation evalNew = this.newEvaluation(suffix, eval, indices);
        WekaEvaluationContainer result = new WekaEvaluationContainer(evalNew);
        return result;
    }

    protected List<WekaEvaluationContainer> doPostProcess(WekaEvaluationContainer cont) {
        ArrayList<WekaEvaluationContainer> result = new ArrayList<WekaEvaluationContainer>();
        List<Evaluation> evals = this.postProcess((Evaluation)cont.getValue("Evaluation", Evaluation.class));
        for (Evaluation eval : evals) {
            result.add(new WekaEvaluationContainer(eval));
        }
        return result;
    }

    public List<WekaEvaluationContainer> postProcess(WekaEvaluationContainer cont) {
        String msg = this.check(cont);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        return this.doPostProcess(cont);
    }

    protected String check(Evaluation eval) {
        if (eval == null) {
            return "No evaluation provided!";
        }
        if (eval.predictions() == null) {
            return "No predictions recorded?";
        }
        return null;
    }

    protected Evaluation newEvaluation(String suffix, Evaluation eval, TIntList indices) {
        Evaluation result;
        Instance inst;
        Prediction pred;
        int i;
        ArrayList preds = eval.predictions();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("new eval: from " + preds.size() + " predictions down to " + indices.size());
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(eval.getHeader().classAttribute().copy("Actual"));
        Instances data = new Instances(eval.getHeader().relationName() + suffix, atts, indices.size());
        data.setClassIndex(data.numAttributes() - 1);
        boolean numeric = eval.getHeader().classAttribute().isNumeric();
        for (i = 0; i < indices.size(); ++i) {
            pred = (Prediction)preds.get(indices.get(i));
            inst = numeric ? new DenseInstance(pred.weight(), new double[]{pred.actual()}) : new DenseInstance(pred.weight(), (double[])((NominalPrediction)pred).distribution().clone());
            data.add(inst);
        }
        try {
            result = new Evaluation(data);
            for (i = 0; i < indices.size(); ++i) {
                inst = data.instance(i);
                pred = (Prediction)preds.get(indices.get(i));
                if (numeric) {
                    result.evaluateModelOnceAndRecordPrediction(new double[]{pred.predicted()}, inst);
                    continue;
                }
                result.evaluateModelOnceAndRecordPrediction((double[])((NominalPrediction)pred).distribution().clone(), inst);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to make fake predictions!", e);
        }
        return result;
    }

    protected abstract List<Evaluation> doPostProcess(Evaluation var1);

    public List<Evaluation> postProcess(Evaluation eval) {
        String msg = this.check(eval);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        return this.doPostProcess(eval);
    }
}

