/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaevaluationpostprocessor;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseInterval;
import adams.core.option.OptionHandler;
import adams.flow.transformer.wekaevaluationpostprocessor.AbstractNumericClassPostProcessor;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.Prediction;

public class SubRange
extends AbstractNumericClassPostProcessor {
    private static final long serialVersionUID = -1598212513856588223L;
    protected BaseInterval[] m_Ranges;

    public String globalInfo() {
        return "Generates an Evaluation object based on the actual class values that fall within the specified interval ranges.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "ranges", (Object)new BaseInterval[0]);
    }

    public void setRanges(BaseInterval[] value) {
        this.m_Ranges = value;
        this.reset();
    }

    public BaseInterval[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The ranges to include.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"ranges", (Object)this.m_Ranges, (String)"ranges: ");
    }

    @Override
    protected List<Evaluation> doPostProcess(Evaluation eval) {
        ArrayList<Evaluation> result = new ArrayList<Evaluation>();
        TIntArrayList indices = new TIntArrayList();
        block0: for (int i = 0; i < eval.predictions().size(); ++i) {
            Prediction pred = (Prediction)eval.predictions().get(i);
            for (int n = 0; n < this.m_Ranges.length; ++n) {
                if (!this.m_Ranges[n].isInside(pred.actual())) continue;
                indices.add(i);
                continue block0;
            }
        }
        String relName = this.m_Ranges.length == 1 ? this.m_Ranges[0].getValue() : Utils.arrayToString((Object)this.m_Ranges);
        result.add(this.newEvaluation("-" + relName, eval, (TIntList)indices));
        return result;
    }
}

