/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.ClassLister;
import adams.core.classmanager.ClassManager;
import adams.data.io.input.AbstractAdamsExperimentReader;
import adams.data.io.input.NestedAdamsExperimentReader;
import adams.data.io.output.AbstractAdamsExperimentWriter;
import adams.data.io.output.NestedAdamsExperimentWriter;
import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.chooser.FileTypeDeterminingFileChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AdamsExperimentFileChooser
extends AbstractConfigurableExtensionFileFilterFileChooser<AbstractAdamsExperimentReader, AbstractAdamsExperimentWriter>
implements FileTypeDeterminingFileChooser<AbstractAdamsExperimentReader, AbstractAdamsExperimentWriter> {
    private static final long serialVersionUID = -6341967475735162796L;
    protected static List<ExtensionFileFilterWithClass> m_ReaderFileFilters;
    protected static List<ExtensionFileFilterWithClass> m_WriterFileFilters;

    public AdamsExperimentFileChooser() {
    }

    public AdamsExperimentFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public AdamsExperimentFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters != null;
    }

    protected void doInitializeFilters() {
        try {
            AdamsExperimentFileChooser.initFilters(true, ClassLister.getSingleton().getClasses(AbstractAdamsExperimentReader.class));
            AdamsExperimentFileChooser.initFilters(false, ClassLister.getSingleton().getClasses(AbstractAdamsExperimentWriter.class));
        }
        catch (Exception e) {
            AdamsExperimentFileChooser.handleException((String)"Failed to initialize Weka loader/saver filters!", (Throwable)e);
        }
    }

    protected static void initFilters(boolean reader, Class[] classes) {
        if (reader && m_ReaderFileFilters != null) {
            return;
        }
        if (!reader && m_WriterFileFilters != null) {
            return;
        }
        if (reader) {
            m_ReaderFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        } else {
            m_WriterFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        }
        for (int i = 0; i < classes.length; ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class cls = classes[i];
            try {
                converter = cls.newInstance();
                if (reader) {
                    desc = ((AbstractAdamsExperimentReader)((Object)converter)).getFormatDescription();
                    ext = ((AbstractAdamsExperimentReader)((Object)converter)).getFormatExtensions();
                } else {
                    desc = ((AbstractAdamsExperimentWriter)((Object)converter)).getFormatDescription();
                    ext = ((AbstractAdamsExperimentWriter)((Object)converter)).getFormatExtensions();
                }
            }
            catch (Exception e) {
                AdamsExperimentFileChooser.handleException((String)("Failed to set up: " + cls), (Throwable)e);
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(cls.getName(), desc, ext);
                m_ReaderFileFilters.add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(cls.getName(), desc, ext);
            m_WriterFileFilters.add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters);
        } else {
            Collections.sort(m_WriterFileFilters);
        }
    }

    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters;
    }

    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    protected Class getReaderClass() {
        return AbstractAdamsExperimentReader.class;
    }

    protected Class getWriterClass() {
        return AbstractAdamsExperimentWriter.class;
    }

    protected AbstractAdamsExperimentReader getDefaultReader() {
        return new NestedAdamsExperimentReader();
    }

    protected AbstractAdamsExperimentWriter getDefaultWriter() {
        return new NestedAdamsExperimentWriter();
    }

    public AbstractAdamsExperimentReader getReaderForFile(File file) {
        return AdamsExperimentFileChooser.readerForFile(file);
    }

    public AbstractAdamsExperimentWriter getWriterForFile(File file) {
        return AdamsExperimentFileChooser.writerForFile(file);
    }

    public static AbstractAdamsExperimentReader readerForFile(File file) {
        AbstractAdamsExperimentReader result = null;
        try {
            AdamsExperimentFileChooser.initFilters(true, ClassLister.getSingleton().getClasses(AbstractAdamsExperimentReader.class));
        }
        catch (Exception e) {
            AdamsExperimentFileChooser.handleException((String)"Failed to initialize ADAMS Experiment readers/writers!", (Throwable)e);
        }
        for (ExtensionFileFilterWithClass filter : m_ReaderFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (AbstractAdamsExperimentReader)((Object)ClassManager.getSingleton().forName(filter.getClassname()).newInstance());
            }
            catch (Exception e) {
                AdamsExperimentFileChooser.handleException((String)("Failed to instantiate reader: " + filter.getClassname()), (Throwable)e);
            }
        }
        return result;
    }

    public static AbstractAdamsExperimentWriter writerForFile(File file) {
        AbstractAdamsExperimentWriter result = null;
        try {
            AdamsExperimentFileChooser.initFilters(false, ClassLister.getSingleton().getClasses(AbstractAdamsExperimentWriter.class.getName()));
        }
        catch (Exception e) {
            AdamsExperimentFileChooser.handleException((String)"Failed to initialize ADAMS Experiment readers/writers!", (Throwable)e);
        }
        for (ExtensionFileFilterWithClass filter : m_WriterFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (AbstractAdamsExperimentWriter)((Object)ClassManager.getSingleton().forName(filter.getClassname()).newInstance());
            }
            catch (Exception e) {
                AdamsExperimentFileChooser.handleException((String)("Failed to instantiate writer: " + filter.getClassname()), (Throwable)e);
            }
        }
        return result;
    }
}

