/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.option.WekaCommandLineHandler;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import weka.core.OptionHandler;
import weka.core.Utils;

public class WekaOptionsConversionPanel
extends BasePanel {
    private static final long serialVersionUID = -5846361688841154052L;
    protected BaseTextAreaWithButtons m_TextAreaInput;
    protected BaseButton m_ButtonInputCopy;
    protected BaseButton m_ButtonInputPaste;
    protected BaseTextAreaWithButtons m_TextAreaCodeOutput;
    protected BaseButton m_ButtonCodeOutputCopy;
    protected BaseButton m_ButtonCodeOutputPaste;
    protected BaseButton m_ButtonConvert;

    protected void initGUI() {
        super.initGUI();
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panelAll = new JPanel(new GridLayout(2, 1));
        this.add(panelAll, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Input"));
        panelAll.add(panel);
        this.m_TextAreaInput = new BaseTextAreaWithButtons();
        panel.add((Component)this.m_TextAreaInput, "Center");
        this.m_ButtonInputCopy = new BaseButton("Copy", (Icon)GUIHelper.getIcon((String)"copy.gif"));
        this.m_ButtonInputCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)WekaOptionsConversionPanel.this.m_TextAreaInput.getComponent()).copy();
            }
        });
        this.m_TextAreaInput.addToButtonsPanel((Component)this.m_ButtonInputCopy);
        this.m_ButtonInputPaste = new BaseButton("Paste", (Icon)GUIHelper.getIcon((String)"paste.gif"));
        this.m_ButtonInputPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)WekaOptionsConversionPanel.this.m_TextAreaInput.getComponent()).paste();
            }
        });
        this.m_TextAreaInput.addToButtonsPanel((Component)this.m_ButtonInputPaste);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Code output"));
        panelAll.add(panel);
        this.m_TextAreaCodeOutput = new BaseTextAreaWithButtons();
        panel.add((Component)this.m_TextAreaCodeOutput, "Center");
        this.m_ButtonCodeOutputCopy = new BaseButton("Copy", (Icon)GUIHelper.getIcon((String)"copy.gif"));
        this.m_ButtonCodeOutputCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)WekaOptionsConversionPanel.this.m_TextAreaCodeOutput.getComponent()).copy();
            }
        });
        this.m_TextAreaCodeOutput.addToButtonsPanel((Component)this.m_ButtonCodeOutputCopy);
        this.m_ButtonCodeOutputPaste = new BaseButton("Paste", (Icon)GUIHelper.getIcon((String)"paste.gif"));
        this.m_ButtonCodeOutputPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseTextArea)WekaOptionsConversionPanel.this.m_TextAreaCodeOutput.getComponent()).paste();
            }
        });
        this.m_TextAreaCodeOutput.addToButtonsPanel((Component)this.m_ButtonCodeOutputPaste);
        panel = new JPanel(new FlowLayout(2));
        this.add(panel, "South");
        this.m_ButtonConvert = new BaseButton("Convert");
        this.m_ButtonConvert.setMnemonic('C');
        this.m_ButtonConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WekaOptionsConversionPanel.this.convert();
            }
        });
        panel.add((Component)this.m_ButtonConvert);
    }

    protected void convert() {
        try {
            WekaCommandLineHandler cmd = new WekaCommandLineHandler();
            Object obj = cmd.fromCommandLine(this.m_TextAreaInput.getText());
            StringBuilder buf = new StringBuilder();
            buf.append("--> String:\n");
            buf.append("\n");
            buf.append("\"" + Utils.backQuoteChars((String)cmd.toCommandLine(obj)) + "\"\n");
            buf.append("\n");
            buf.append("\n");
            buf.append("--> Test class:\n");
            buf.append("\n");
            buf.append("public class OptionsTest {\n");
            buf.append("\n");
            buf.append("  public static void main(String[] args) throws Exception {\n");
            buf.append("    // create new instance of scheme\n");
            buf.append("    " + obj.getClass().getName() + " scheme = new " + obj.getClass().getName() + "();\n");
            if (obj instanceof OptionHandler) {
                OptionHandler handler = (OptionHandler)obj;
                buf.append("    \n");
                buf.append("    // set options\n");
                buf.append("    scheme.setOptions(weka.core.Utils.splitOptions(\"" + Utils.backQuoteChars((String)Utils.joinOptions((String[])handler.getOptions())) + "\"));\n");
                buf.append("  }\n");
            }
            buf.append("}\n");
            this.m_TextAreaCodeOutput.setText(buf.toString());
            ((BaseTextArea)this.m_TextAreaCodeOutput.getComponent()).setCaretPosition(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to convert options:\n" + ex));
        }
    }
}

