/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.weka;

import adams.core.logging.LoggingHelper;
import adams.gui.chooser.DatasetFileChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.tools.weka.AbstractPanelWithFile;
import java.awt.Component;
import java.io.File;
import weka.core.Instances;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;

public class CostCurvePanel
extends AbstractPanelWithFile<DatasetFileChooserPanel> {
    private static final long serialVersionUID = -485114976896228362L;
    protected ThresholdVisualizePanel m_PanelCurve;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelCurve = new ThresholdVisualizePanel();
        this.add((Component)this.m_PanelCurve, "Center");
    }

    @Override
    protected DatasetFileChooserPanel createChooserPanel() {
        DatasetFileChooserPanel result = new DatasetFileChooserPanel();
        result.addChangeListener(e -> this.display());
        return result;
    }

    @Override
    public void setCurrent(File file) {
        ((DatasetFileChooserPanel)this.m_PanelChooser).setCurrent(file);
    }

    protected void display() {
        Instances result;
        File file = (File)((DatasetFileChooserPanel)this.m_PanelChooser).getCurrent();
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        try {
            result = ((DatasetFileChooserPanel)this.m_PanelChooser).getLoader().getDataSet();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Error loading file '" + file + "':\n" + LoggingHelper.throwableToString((Throwable)e)));
            return;
        }
        result.setClassIndex(result.numAttributes() - 1);
        this.m_PanelCurve.removeAllPlots();
        PlotData2D plot = new PlotData2D(result);
        plot.setPlotName(result.relationName());
        plot.m_displayAllPoints = true;
        boolean[] connectPoints = new boolean[result.numInstances()];
        for (int cp = 1; cp < connectPoints.length; ++cp) {
            connectPoints[cp] = true;
        }
        try {
            plot.setConnectPoints(connectPoints);
            this.m_PanelCurve.addPlot(plot);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getParent(), (String)("Error adding plot:\n" + LoggingHelper.throwableToString((Throwable)e)));
            return;
        }
    }
}

