/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.flow.container.WekaTrainTestSetContainer;
import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.SplitGenerator;
import weka.core.Instances;

public class Split
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;
    public static final int NUM_CONTAINERS_THRESHOLD = 10;
    protected SplitGenerator m_LastSplitter;

    public Split() {
        this.setName("Split");
        this.setIcon("percentage.gif");
        this.setAsynchronous(true);
        this.m_LastSplitter = new DefaultRandomSplitGenerator();
    }

    protected void doActionPerformed(ActionEvent e) {
        int retVal;
        GenericObjectEditorDialog dialog = GUIHelper.getParentDialog((Container)((Object)this.getOwner())) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)((Object)this.getOwner())), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)((Object)this.getOwner())), true);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(SplitGenerator.class);
        dialog.setCurrent((Object)this.m_LastSplitter);
        dialog.setTitle("Split");
        dialog.setLocationRelativeTo((Component)((Object)this.getOwner().getOwner()));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        SplitGenerator splitter = (SplitGenerator)dialog.getCurrent();
        this.m_LastSplitter = (SplitGenerator)dialog.getCurrent();
        DataContainer cont = this.getSelectedData()[0];
        this.logMessage("Splitting dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
        splitter.setData(cont.getData());
        ArrayList<WekaTrainTestSetContainer> ttconts = new ArrayList<WekaTrainTestSetContainer>();
        while (splitter.hasNext()) {
            ttconts.add(splitter.next());
        }
        if (ttconts.size() > 10 && (retVal = GUIHelper.showConfirmMessage((Component)((Object)this.getOwner()), (String)("Splitter generated " + ttconts.size() + " containers (with train/test sets), proceed?"))) != 0) {
            this.logMessage("Splitting dataset aborted!");
            return;
        }
        TIntArrayList indices = new TIntArrayList();
        String suffix = "";
        for (int i = 0; i < ttconts.size(); ++i) {
            WekaTrainTestSetContainer ttcont = (WekaTrainTestSetContainer)((Object)ttconts.get(i));
            if (ttconts.size() > 1) {
                suffix = "-" + (i + 1);
            }
            MemoryContainer trainCont = new MemoryContainer((Instances)ttcont.getValue("Train"));
            trainCont.getData().setRelationName(cont.getData().relationName() + "-train" + suffix);
            MemoryContainer testCont = new MemoryContainer((Instances)ttcont.getValue("Test"));
            testCont.getData().setRelationName(cont.getData().relationName() + "-test" + suffix);
            this.getData().add(trainCont);
            this.getData().add(testCont);
            indices.add(this.getData().size() - 2);
            indices.add(this.getData().size() - 1);
        }
        this.logMessage("Successfully split " + cont.getID() + " into " + ttconts.size() * 2 + " datasets!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, indices.toArray()));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

