/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.output;

import adams.core.Shortening;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.util.ArrayList;

public class RunInformationHelper {
    public static final int MAX_HTML_LENGTH = 80;

    public static String toString(SpreadSheet info) {
        int i;
        StringBuilder result = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int len = 0;
        for (Row row : info.rows()) {
            keys.add(row.getCell(0).getContent());
            values.add(row.getCell(1).getContent());
            len = Math.max(len, ((String)keys.get(keys.size() - 1)).length());
        }
        for (i = 0; i < keys.size(); ++i) {
            while (((String)keys.get(i)).length() < len) {
                keys.set(i, (String)keys.get(i) + ".");
            }
            keys.set(i, (String)keys.get(i) + ": ");
        }
        for (i = 0; i < keys.size(); ++i) {
            result.append((String)keys.get(i));
            result.append((String)values.get(i));
            result.append("\n");
        }
        return result.toString();
    }

    public static String toHTML(SpreadSheet info) {
        StringBuilder result = new StringBuilder();
        result.append("<table>");
        for (Row row : info.rows()) {
            result.append("<tr>");
            result.append("<td>");
            result.append(row.getCell(0).getContent());
            result.append("</td>");
            result.append("<td>");
            result.append(Shortening.shortenEnd((String)row.getCell(1).getContent(), (int)80));
            result.append("</td>");
            result.append("</tr>");
        }
        result.append("</table>");
        return result.toString();
    }
}

