/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.ListHelper;
import adams.core.logging.LoggingLevel;
import adams.gui.core.BaseFlatButton;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.BaseSplitButton;
import adams.gui.core.BaseTable;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.UndoEvent;
import adams.gui.event.UndoListener;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import adams.gui.tools.wekainvestigator.datatable.action.Save;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithDataTable;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class AbstractInvestigatorTabWithEditableDataTable
extends AbstractInvestigatorTabWithDataTable
implements UndoListener {
    private static final long serialVersionUID = -94945456385486233L;
    protected BaseFlatButton m_ButtonActivate;
    protected BaseFlatButton m_ButtonRemove;
    protected BaseFlatButton m_ButtonSave;
    protected BaseSplitButton m_ButtonAction;
    protected BaseFlatButton m_ButtonUp;
    protected BaseFlatButton m_ButtonDown;
    protected BaseFlatButton m_ButtonUndo;
    protected List<AbstractEditableDataTableAction> m_Actions;

    @Override
    protected void initialize() {
        Class[] classes;
        super.initialize();
        this.m_Owner = null;
        this.m_Actions = new ArrayList<AbstractEditableDataTableAction>();
        for (Class cls : classes = AbstractEditableDataTableAction.getActions()) {
            try {
                AbstractEditableDataTableAction action = (AbstractEditableDataTableAction)((Object)cls.newInstance());
                action.setOwner(this);
                this.m_Actions.add(action);
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)LoggingLevel.SEVERE, "Failed to instantiate action: " + cls.getName(), (Throwable)e);
            }
        }
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ButtonActivate = new BaseFlatButton("Activate", (Icon)GUIHelper.getIcon((String)"location.png"));
        this.m_ButtonActivate.addActionListener(e -> this.activate(this.m_Table.getSelectedRow()));
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonActivate);
        this.m_ButtonRemove = new BaseFlatButton("Remove", (Icon)GUIHelper.getIcon((String)"delete.gif"));
        this.m_ButtonRemove.addActionListener(e -> this.removeData(this.m_Table.getSelectedRows()));
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_ButtonUndo = new BaseFlatButton("Undo", (Icon)GUIHelper.getIcon((String)"undo.gif"));
        this.m_ButtonUndo.addActionListener(e -> this.undo(this.m_Table.getSelectedRows()));
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonUndo);
        this.m_ButtonSave = new BaseFlatButton("Save", (Icon)GUIHelper.getIcon((String)"save.gif"));
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonSave);
        this.m_ButtonAction = new BaseSplitButton("...", (Icon)GUIHelper.getEmptyIcon());
        this.m_ButtonAction.setAlwaysDropdown(false);
        this.m_ButtonAction.setButtonEnabled(true);
        for (AbstractEditableDataTableAction action : this.m_Actions) {
            if (action instanceof Save) {
                this.m_ButtonSave.setAction((Action)((Object)action));
                continue;
            }
            this.m_ButtonAction.add((Action)((Object)action));
        }
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonAction);
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.m_ButtonUp = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"arrow_up.gif"));
        this.m_ButtonUp.addActionListener(e -> {
            ListHelper.moveUp(this.getData(), (int[])this.getSelectedRows());
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1));
        });
        this.m_ButtonDown = new BaseFlatButton((Icon)GUIHelper.getIcon((String)"arrow_down.gif"));
        this.m_ButtonDown.addActionListener(e -> {
            ListHelper.moveDown(this.getData(), (int[])this.getSelectedRows());
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1));
        });
        panel.add((Component)this.m_ButtonUp);
        panel.add((Component)this.m_ButtonDown);
        this.m_Table.addToButtonsPanel(panel);
        ((BaseTable)this.m_Table.getComponent()).addCellPopupMenuListener(e -> this.showDataTablePopup(e));
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    @Override
    protected boolean hasReadOnlyTable() {
        return false;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        super.dataChanged(e);
        for (DataContainer cont : this.getData()) {
            cont.getUndo().addUndoListener((UndoListener)this);
        }
        this.updateButtons();
    }

    @Override
    protected void dataTableSelectionChanged() {
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonActivate.setEnabled(!this.isBusy() && this.m_Table.getSelectedRowCount() == 1);
        this.m_ButtonRemove.setEnabled(!this.isBusy() && this.m_Table.getSelectedRowCount() > 0);
        for (AbstractEditableDataTableAction action : this.m_Actions) {
            action.update();
        }
        this.m_ButtonUp.setEnabled(!this.isBusy() && this.m_Model.canMoveUp(this.getSelectedRows()));
        this.m_ButtonDown.setEnabled(!this.isBusy() && this.m_Model.canMoveDown(this.getSelectedRows()));
        int[] rows = this.m_Table.getSelectedRows();
        boolean enabled = false;
        for (Object row : (Object)rows) {
            DataContainer cont;
            if (row >= this.getData().size() || !(cont = this.getData().get((int)row)).isUndoSupported() || !cont.getUndo().canUndo()) continue;
            enabled = true;
            break;
        }
        this.m_ButtonUndo.setEnabled(!this.isBusy() && enabled);
    }

    public void undoOccurred(UndoEvent e) {
        this.updateButtons();
    }

    protected void showDataTablePopup(MouseEvent e) {
        BasePopupMenu result = new BasePopupMenu();
        for (AbstractEditableDataTableAction action : this.m_Actions) {
            action.update();
            result.add((Action)((Object)action));
        }
        result.show(e.getComponent(), e.getX(), e.getY());
    }
}

