/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.ClassLister;
import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.SerializationHelper;
import adams.core.option.OptionUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.AdjustableGridPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseMenu;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.ConsolePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericArrayEditorDialog;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import adams.gui.tools.wekainvestigator.output.AbstractResultItem;
import adams.gui.tools.wekainvestigator.output.RunInformationHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.evaluation.AbstractClustererEvaluation;
import adams.gui.tools.wekainvestigator.tab.clustertab.history.AbstractHistoryPopupMenuItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.output.AbstractOutputGenerator;
import adams.gui.tools.wekainvestigator.tab.clustertab.output.TextStatistics;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;

public class ClusterTab
extends AbstractInvestigatorTab {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final String KEY_HISTORY = "history";
    public static final String KEY_OUTPUTGENERATORS = "output generators";
    public static final String KEY_LEFTPANELWIDTH = "leftpanelwidth";
    public static final String KEY_CLUSTERER = "clusterer";
    public static final String KEY_EVALUATION = "evaluation";
    public static final String KEY_EVALUATION_PREFIX = "evaluation.";
    protected GenericObjectEditorPanel m_PanelGOE;
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PanelLeft;
    protected JPanel m_PanelRight;
    protected JPanel m_PanelEvaluation;
    protected BaseComboBox<AbstractClustererEvaluation> m_ComboBoxEvaluations;
    protected DefaultComboBoxModel<AbstractClustererEvaluation> m_ModelEvaluations;
    protected JPanel m_PanelEvaluationSetup;
    protected AbstractClustererEvaluation m_CurrentEvaluation;
    protected Clusterer m_CurrentClusterer;
    protected BaseButton m_ButtonOutputGenerators;
    protected JPanel m_PanelExecutionButtons;
    protected BaseButton m_ButtonStart;
    protected BaseButton m_ButtonStop;
    protected HistoryPanel m_History;
    protected BaseStatusBar m_StatusBar;
    protected AbstractOutputGenerator[] m_OutputGenerators;

    @Override
    protected void initialize() {
        String[] cmds;
        super.initialize();
        Properties props = InvestigatorPanel.getProperties();
        this.m_CurrentEvaluation = null;
        this.m_CurrentClusterer = null;
        try {
            cmds = OptionUtils.splitOptions((String)props.getProperty("Cluster.OutputGenerators", TextStatistics.class.getName()));
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to parse output generators:\n" + props.getProperty("Cluster.OutputGenerators"), (Throwable)e);
            cmds = new String[]{TextStatistics.class.getName()};
        }
        ArrayList<AbstractOutputGenerator> generators = new ArrayList<AbstractOutputGenerator>();
        for (int i = 0; i < cmds.length; ++i) {
            try {
                AbstractOutputGenerator generator = (AbstractOutputGenerator)((Object)OptionUtils.forAnyCommandLine(AbstractOutputGenerator.class, (String)cmds[i]));
                generators.add(generator);
                continue;
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate output generator:\n" + cmds[i], (Throwable)e);
            }
        }
        this.m_OutputGenerators = generators.toArray(new AbstractOutputGenerator[generators.size()]);
    }

    protected void initGUI() {
        Class[] classes;
        SimpleKMeans cls;
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_ContentPanel.setLayout((LayoutManager)new BorderLayout());
        this.m_ContentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        try {
            cls = (Clusterer)OptionUtils.forAnyCommandLine(Clusterer.class, (String)InvestigatorPanel.getProperties().getProperty("Cluster.Clusterer", SimpleKMeans.class.getName()));
        }
        catch (Exception e2) {
            cls = new SimpleKMeans();
        }
        this.m_PanelGOE = new GenericObjectEditorPanel(Clusterer.class, (Object)cls, true);
        this.m_PanelGOE.setPrefix("Clusterer ");
        this.m_PanelGOE.moveChooseButton(true);
        this.m_PanelGOE.addChangeListener(e -> this.updateButtons());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_PanelGOE, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.m_ContentPanel.add((Component)panel, (Object)"North");
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_ContentPanel.add((Component)this.m_SplitPane, (Object)"Center");
        this.m_PanelLeft = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)this.m_PanelLeft);
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        this.m_SplitPane.setDividerLocation(props.getInteger("Cluster.LeftPanelWidth", Integer.valueOf(200)).intValue());
        this.m_PanelEvaluation = new JPanel(new BorderLayout());
        this.m_PanelEvaluation.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        this.m_PanelLeft.add((Component)this.m_PanelEvaluation, "North");
        this.m_ModelEvaluations = new DefaultComboBoxModel();
        for (Class c : classes = AbstractClustererEvaluation.getEvaluations()) {
            try {
                AbstractClustererEvaluation eval = (AbstractClustererEvaluation)((Object)c.newInstance());
                eval.setOwner(this);
                this.m_ModelEvaluations.addElement(eval);
            }
            catch (Exception e3) {
                ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate clusterer evaluation: " + c.getName(), (Throwable)e3);
            }
        }
        this.m_ComboBoxEvaluations = new BaseComboBox(this.m_ModelEvaluations);
        this.m_ComboBoxEvaluations.addActionListener(e -> {
            if (this.m_ComboBoxEvaluations.getSelectedIndex() == -1) {
                return;
            }
            this.m_CurrentEvaluation = (AbstractClustererEvaluation)((Object)((Object)this.m_ComboBoxEvaluations.getSelectedItem()));
            this.m_PanelEvaluationSetup.removeAll();
            this.m_PanelEvaluationSetup.add(this.m_CurrentEvaluation.getPanel());
            this.m_CurrentEvaluation.update();
            this.m_PanelEvaluationSetup.invalidate();
            this.m_PanelEvaluationSetup.revalidate();
            this.m_PanelEvaluationSetup.doLayout();
        });
        this.m_PanelEvaluation.add((Component)this.m_ComboBoxEvaluations, "North");
        this.m_PanelEvaluationSetup = new JPanel(new BorderLayout());
        this.m_PanelEvaluation.add((Component)this.m_PanelEvaluationSetup, "Center");
        JPanel buttonsAll = new JPanel(new GridLayout(2, 1));
        this.m_PanelEvaluation.add((Component)buttonsAll, "South");
        this.m_ButtonOutputGenerators = new BaseButton("...");
        this.m_ButtonOutputGenerators.addActionListener(ActionEvent2 -> this.editOutputGenerators());
        JLabel label = new JLabel("Output generators");
        label.setLabelFor((Component)this.m_ButtonOutputGenerators);
        panel = new JPanel(new FlowLayout(0));
        panel.add(label);
        panel.add((Component)this.m_ButtonOutputGenerators);
        buttonsAll.add(panel);
        this.m_PanelExecutionButtons = new JPanel(new FlowLayout(0));
        buttonsAll.add(this.m_PanelExecutionButtons);
        this.m_ButtonStart = new BaseButton("Start");
        this.m_ButtonStart.addActionListener(e -> this.startExecution());
        this.m_PanelExecutionButtons.add((Component)this.m_ButtonStart);
        this.m_ButtonStop = new BaseButton("Stop");
        this.m_ButtonStop.addActionListener(e -> this.stopExecution());
        this.m_PanelExecutionButtons.add((Component)this.m_ButtonStop);
        this.m_History = new HistoryPanel(this);
        this.m_History.setToolTipsEnabled(props.getBoolean("General.ResultHistoryToolTips", Boolean.valueOf(true)));
        this.m_PanelLeft.add((Component)((Object)this.m_History), "Center");
        this.m_StatusBar = new BaseStatusBar();
        this.m_StatusBar.setExpiryTime(true, 60);
        this.m_ContentPanel.add((Component)this.m_StatusBar, (Object)"South");
    }

    protected void finishInit() {
        super.finishInit();
        Properties props = InvestigatorPanel.getProperties();
        String evalDefault = props.getProperty("Cluster.Evaluation", "");
        int evalIndex = 0;
        for (int i = 0; i < this.m_ModelEvaluations.getSize(); ++i) {
            if (!((Object)((Object)this.m_ModelEvaluations.getElementAt(i))).getClass().getName().equals(evalDefault)) continue;
            evalIndex = i;
            break;
        }
        this.m_ComboBoxEvaluations.setSelectedIndex(evalIndex);
    }

    @Override
    public String getTitle() {
        return "Cluster";
    }

    @Override
    public String getTabIcon() {
        return "clusterer.png";
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        for (int i = 0; i < this.m_ModelEvaluations.getSize(); ++i) {
            if (e.getType() == 5) {
                this.m_ModelEvaluations.getElementAt(i).activate(e.getRows()[0]);
                continue;
            }
            this.m_ModelEvaluations.getElementAt(i).update();
        }
        this.updateButtons();
    }

    protected void editOutputGenerators() {
        GenericArrayEditorDialog dialog = this.getParentDialog() != null ? new GenericArrayEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericArrayEditorDialog(this.getParentFrame(), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setOkAlwaysEnabled(true);
        dialog.setTitle("Output generators");
        dialog.setCurrent((Object)this.m_OutputGenerators);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        this.m_OutputGenerators = (AbstractOutputGenerator[])dialog.getCurrent();
    }

    protected void startExecution() {
        this.m_CurrentClusterer = (Clusterer)this.m_PanelGOE.getCurrent();
        this.startExecution(new InvestigatorTabJob(this, "Starting evaluation '" + this.m_CurrentEvaluation.getName() + "' using: " + OptionUtils.getCommandLine((Object)this.m_CurrentClusterer)){

            @Override
            protected void doRun() {
                ResultItem item;
                try {
                    item = ClusterTab.this.m_CurrentEvaluation.init(ClusterTab.this.m_CurrentClusterer);
                    ClusterTab.this.m_CurrentEvaluation.addToHistory(ClusterTab.this.m_History, item);
                    String entry = item.getName();
                    ClusterTab.this.m_CurrentEvaluation.evaluate(ClusterTab.this.m_CurrentClusterer, item);
                    if (!entry.equals(item.getName())) {
                        ClusterTab.this.m_History.renameEntry(entry, item.getName());
                    }
                    ClusterTab.this.logMessage("Finished evaluation '" + ClusterTab.this.m_CurrentEvaluation.getName() + "' using: " + OptionUtils.getCommandLine((Object)ClusterTab.this.m_CurrentClusterer));
                }
                catch (Exception e) {
                    ClusterTab.this.logError("Failed to evaluate clusterer", e, "Clusterer evaluation");
                    item = null;
                }
                if (item != null) {
                    ClusterTab.this.generateOutput(item);
                }
            }
        });
    }

    @Override
    protected void postStartExecution(InvestigatorTabJob job) {
        super.postStartExecution(job);
        this.updateButtons();
    }

    @Override
    protected void postStopExecution() {
        super.postStopExecution();
        this.logMessage("Stopped evaluation '" + this.m_CurrentEvaluation.getName() + "' using: " + OptionUtils.getCommandLine((Object)this.m_CurrentClusterer));
        this.updateButtons();
    }

    @Override
    protected void postExecutionFinished() {
        super.postExecutionFinished();
        this.logMessage("Finished evaluation '" + this.m_CurrentEvaluation.getName() + "' using: " + OptionUtils.getCommandLine((Object)this.m_CurrentClusterer));
        this.updateButtons();
    }

    public void generateOutput(ResultItem item) {
        for (int i = 0; i < this.m_OutputGenerators.length; ++i) {
            try {
                if (!this.m_OutputGenerators[i].canGenerateOutput(item)) continue;
                this.m_OutputGenerators[i].generateOutput(item);
                continue;
            }
            catch (Exception e) {
                this.logError("Failed to generate output with " + this.m_OutputGenerators[i].toCommandLine(), e, "Clusterer output generation");
            }
        }
    }

    public void updateButtons() {
        Clusterer cls = (Clusterer)this.m_PanelGOE.getCurrent();
        String msg = this.m_CurrentEvaluation.canEvaluate(cls);
        this.m_ButtonStart.setEnabled(!this.isBusy() && this.m_CurrentEvaluation != null && msg == null);
        this.m_ButtonStart.setToolTipText(GUIHelper.processTipText((String)msg));
        this.m_ButtonStop.setEnabled(this.isBusy());
    }

    @Override
    public void logMessage(String msg) {
        super.logMessage(msg);
        this.m_StatusBar.showStatus(msg);
    }

    @Override
    public void logError(String msg, Throwable t, String title) {
        super.logError(msg, t, title);
        this.m_StatusBar.showStatus(msg);
    }

    @Override
    public void logError(String msg, String title) {
        super.logError(msg, title);
        this.m_StatusBar.showStatus(msg);
    }

    @Override
    public void showStatus(String msg) {
        super.showStatus(msg);
        this.m_StatusBar.showStatus(msg);
    }

    public JPanel getPanelLeft() {
        return this.m_PanelLeft;
    }

    public JPanel getPanelRight() {
        return this.m_PanelRight;
    }

    public AbstractOutputGenerator[] getOutputGenerators() {
        return this.m_OutputGenerators;
    }

    @Override
    protected Map<String, Object> doSerialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.doSerialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_LEFTPANELWIDTH, this.m_SplitPane.getDividerLocation());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_CLUSTERER, OptionUtils.getCommandLine((Object)this.m_PanelGOE.getCurrent()));
            result.put(KEY_EVALUATION, this.m_ComboBoxEvaluations.getSelectedIndex());
            result.put(KEY_OUTPUTGENERATORS, OptionUtils.getCommandLines((Object[])this.m_OutputGenerators));
        }
        for (int i = 0; i < this.m_ModelEvaluations.getSize(); ++i) {
            AbstractClustererEvaluation eval = this.m_ModelEvaluations.getElementAt(i);
            result.put(KEY_EVALUATION_PREFIX + eval.getName(), eval.serialize(options));
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.HISTORY)) {
            result.put(KEY_HISTORY, this.m_History.serialize());
        }
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_LEFTPANELWIDTH)) {
            this.m_SplitPane.setDividerLocation(((Number)data.get(KEY_LEFTPANELWIDTH)).intValue());
        }
        if (data.containsKey(KEY_CLUSTERER)) {
            try {
                this.m_CurrentClusterer = (Clusterer)OptionUtils.forAnyCommandLine(Clusterer.class, (String)((String)data.get(KEY_CLUSTERER)));
                this.m_PanelGOE.setCurrent((Object)this.m_CurrentClusterer);
            }
            catch (Exception e) {
                errors.add("Failed to restore clusterer: " + data.get(KEY_CLUSTERER), (Throwable)e);
            }
        }
        if (data.containsKey(KEY_EVALUATION)) {
            this.m_ComboBoxEvaluations.setSelectedIndex(((Number)data.get(KEY_EVALUATION)).intValue());
        }
        for (int i = 0; i < this.m_ModelEvaluations.getSize(); ++i) {
            AbstractClustererEvaluation eval = this.m_ModelEvaluations.getElementAt(i);
            if (!data.containsKey(KEY_EVALUATION_PREFIX + eval.getName())) continue;
            Map evaldata = (Map)data.get(KEY_EVALUATION_PREFIX + eval.getName());
            eval.deserialize(evaldata, errors);
        }
        if (data.containsKey(KEY_HISTORY)) {
            this.m_History.deserialize(data.get(KEY_HISTORY), errors);
        }
        if (data.containsKey(KEY_OUTPUTGENERATORS)) {
            try {
                this.m_OutputGenerators = (AbstractOutputGenerator[])OptionUtils.forCommandLines(AbstractOutputGenerator.class, (String[])this.toParamsArray(data.get(KEY_OUTPUTGENERATORS)));
            }
            catch (Exception e) {
                errors.add("Failed to restore output generators!", (Throwable)e);
            }
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_History.clear();
    }

    public static class HistoryPanel
    extends AbstractNamedHistoryPanel<ResultItem>
    implements AbstractNamedHistoryPanel.HistoryEntryToolTipProvider<ResultItem> {
        private static final long serialVersionUID = 8740813441072965573L;
        protected ClusterTab m_Owner;
        protected BaseFileChooser m_ModelFileChooser;

        public HistoryPanel(ClusterTab owner) {
            this.m_Owner = owner;
            this.setAllowRemove(true);
            this.setAllowRename(false);
        }

        protected void initialize() {
            super.initialize();
            ExtensionFileFilter filter = ExtensionFileFilter.getModelFileFilter();
            this.m_ModelFileChooser = new BaseFileChooser();
            this.m_ModelFileChooser.addChoosableFileFilter((FileFilter)filter);
            this.m_ModelFileChooser.setFileFilter((FileFilter)filter);
        }

        public String createHistoryEntryToolTip(AbstractNamedHistoryPanel<ResultItem> history, int index) {
            String result = null;
            ResultItem item = (ResultItem)((Object)history.getEntry(index));
            if (item.hasRunInformation()) {
                result = "<html>" + RunInformationHelper.toHTML(item.getRunInformation().toSpreadSheet()) + "</html>";
            }
            return result;
        }

        public void setToolTipsEnabled(boolean value) {
            if (value) {
                this.setHistoryEntryToolTipProvider(this);
            } else {
                this.setHistoryEntryToolTipProvider(null);
            }
        }

        public boolean getToolTipsEnabled() {
            return this.getHistoryEntryToolTipProvider() != null;
        }

        public void clear() {
            for (ResultItem item : this.m_Entries.values()) {
                item.cleanUp();
            }
            super.clear();
        }

        public ResultItem removeEntry(String name) {
            ResultItem result = (ResultItem)((Object)super.removeEntry(name));
            if (result != null) {
                result.cleanUp();
            }
            return result;
        }

        protected void updateEntry(String name) {
            this.m_Owner.getPanelRight().removeAll();
            if (name != null && this.hasEntry(name)) {
                this.m_Owner.getPanelRight().add((Component)((Object)((ResultItem)((Object)this.getEntry(name))).getTabbedPane()));
            }
            this.m_Owner.getPanelRight().invalidate();
            this.m_Owner.getPanelRight().revalidate();
            this.m_Owner.getPanelRight().doLayout();
            this.m_Owner.getPanelRight().repaint();
        }

        protected void saveModel(ResultItem item) {
            if (!item.hasModel()) {
                GUIHelper.showErrorMessage(null, (String)"No clusterer available!");
                return;
            }
            int retVal = this.m_ModelFileChooser.showSaveDialog((Component)((Object)this));
            if (retVal != 0) {
                return;
            }
            try {
                if (item.hasHeader()) {
                    SerializationHelper.writeAll((String)this.m_ModelFileChooser.getSelectedFile().getAbsolutePath(), (Object[])new Object[]{item.getModel(), item.getHeader()});
                } else {
                    SerializationHelper.write((String)this.m_ModelFileChooser.getSelectedFile().getAbsolutePath(), (Object)item.getModel());
                }
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save model to: " + this.m_ModelFileChooser.getSelectedFile()), (Throwable)e);
            }
        }

        protected void regenerateOutput(final ResultItem item) {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    item.getTabbedPane().removeAll();
                    for (int i = 0; i < m_Owner.getOutputGenerators().length; ++i) {
                        try {
                            m_Owner.getOutputGenerators()[i].generateOutput(item);
                            continue;
                        }
                        catch (Exception e) {
                            m_Owner.logError("Failed to generate output with " + m_Owner.getOutputGenerators()[i].toCommandLine(), e, "Clusterer output generation");
                        }
                    }
                    return null;
                }
            };
            worker.execute();
        }

        protected AbstractOutputGenerator configureOutput(AbstractOutputGenerator generator) {
            GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Configure output");
            dialog.getGOEEditor().setCanChangeClassInDialog(false);
            dialog.getGOEEditor().setClassType(AbstractOutputGenerator.class);
            dialog.setCurrent((Object)generator);
            dialog.pack();
            dialog.setLocationRelativeTo((Component)this.getParent());
            dialog.setVisible(true);
            if (dialog.getResult() != 0) {
                return null;
            }
            return (AbstractOutputGenerator)((Object)dialog.getCurrent());
        }

        protected void generateOutput(AbstractOutputGenerator generator, final ResultItem item) {
            final AbstractOutputGenerator current = this.configureOutput(generator);
            if (current == null) {
                return;
            }
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    String msg = current.generateOutput(item);
                    if (msg != null) {
                        m_Owner.logError("Failed to generate output using: " + current.toCommandLine() + "\n" + msg, "Error generating output");
                    }
                    return null;
                }
            };
            worker.execute();
        }

        protected void compareOutput(AbstractOutputGenerator generator, final int[] indices) {
            final AbstractOutputGenerator current = this.configureOutput(generator);
            if (current == null) {
                return;
            }
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    AdjustableGridPanel panel;
                    ArrayList<JComponent> comps = new ArrayList<JComponent>();
                    ArrayList<String> labels = new ArrayList<String>();
                    MessageCollection errors = new MessageCollection();
                    for (int index : indices) {
                        ResultItem item = (ResultItem)((Object)this.getEntry(index));
                        JComponent comp = current.createOutput(item, errors);
                        if (comp == null) continue;
                        comps.add(comp);
                        labels.add(this.getEntryName(index));
                    }
                    if (comps.size() > 0) {
                        panel = new AdjustableGridPanel();
                        for (int i = 0; i < comps.size(); ++i) {
                            JPanel subPanel = new JPanel(new BorderLayout());
                            JLabel label = new JLabel((String)labels.get(i));
                            subPanel.add((Component)label, "North");
                            subPanel.add((Component)comps.get(i), "Center");
                            panel.addItem((Component)subPanel);
                        }
                        panel.updateLayout();
                    } else {
                        panel = null;
                    }
                    if (!errors.isEmpty()) {
                        m_Owner.logError("Failed to generate output using: " + current.toCommandLine() + "\n" + errors, "Error generating output");
                    }
                    if (panel != null) {
                        ApprovalDialog dialog = m_Owner.getParentDialog() != null ? new ApprovalDialog(m_Owner.getParentDialog(), Dialog.ModalityType.MODELESS) : new ApprovalDialog(m_Owner.getParentFrame(), false);
                        dialog.setDefaultCloseOperation(2);
                        dialog.setTitle("Compare output");
                        dialog.getContentPane().add((Component)new BaseScrollPane((Component)panel), "Center");
                        dialog.setSize(GUIHelper.makeWider((Dimension)GUIHelper.getDefaultDialogDimension()));
                        dialog.setLocationRelativeTo((Component)dialog.getParent());
                        dialog.setCancelVisible(false);
                        dialog.setApproveCaption("Close");
                        SendToActionSupporter sendTo = new SendToActionSupporter(){

                            public Class[] getSendToClasses() {
                                return new Class[]{JComponent.class};
                            }

                            public boolean hasSendToItem(Class[] cls) {
                                return SendToActionUtils.isAvailable(JComponent.class, (Class[])cls);
                            }

                            public Object getSendToItem(Class[] cls) {
                                if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls)) {
                                    return panel;
                                }
                                return null;
                            }
                        };
                        JMenuBar menubar = new JMenuBar();
                        JMenu menu = new JMenu("File");
                        menubar.add(menu);
                        SendToActionUtils.addSendToSubmenu((SendToActionSupporter)sendTo, (JMenu)menu);
                        menu.addSeparator();
                        JMenuItem item = new JMenuItem("Close", GUIHelper.getIcon((String)"exit.png"));
                        item.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
                        item.addActionListener(e -> dialog.setVisible(false));
                        menu.add(item);
                        dialog.setJMenuBar(menubar);
                        dialog.setVisible(true);
                    }
                    return null;
                }
            };
            worker.execute();
        }

        protected BasePopupMenu createPopup(MouseEvent e) {
            AbstractOutputGenerator generator;
            Class[] classes;
            BasePopupMenu result = super.createPopup(e);
            int[] indices = this.getSelectedIndices();
            result.addSeparator();
            JMenuItem menuitem = new JMenuItem("Copy setup");
            menuitem.setEnabled(indices.length == 1);
            menuitem.addActionListener(ae -> {
                String setup = OptionUtils.getCommandLine((Object)((ResultItem)((Object)((Object)this.getEntry(indices[0])))).getTemplate());
                ClipboardHelper.copyToClipboard((String)setup);
            });
            result.add(menuitem);
            menuitem = new JMenuItem("Save model...");
            menuitem.setEnabled(indices.length == 1 && ((ResultItem)((Object)this.getEntry(indices[0]))).hasModel());
            menuitem.addActionListener(ae -> this.saveModel((ResultItem)((Object)((Object)this.getEntry(indices[0])))));
            result.add(menuitem);
            menuitem = new JMenuItem("Regenerate output" + (this.m_Owner.getOutputGenerators().length > 1 ? "s" : ""));
            menuitem.setEnabled(indices.length >= 1);
            menuitem.addActionListener(ae -> {
                for (int index : indices) {
                    this.regenerateOutput((ResultItem)((Object)((Object)this.getEntry(index))));
                }
            });
            result.add(menuitem);
            BaseMenu submenu = new BaseMenu("Additional output");
            for (Class cls : classes = ClassLister.getSingleton().getClasses(AbstractOutputGenerator.class)) {
                try {
                    generator = (AbstractOutputGenerator)((Object)cls.newInstance());
                    menuitem = new JMenuItem(generator.getTitle());
                    menuitem.setEnabled(indices.length == 1 && generator.canGenerateOutput((AbstractResultItem)((Object)this.getEntry(indices[0]))));
                    menuitem.addActionListener(ae -> this.generateOutput(generator, (ResultItem)((Object)((Object)this.getEntry(indices[0])))));
                    submenu.add(menuitem);
                }
                catch (Exception ex) {
                    ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate output generator: " + cls.getName(), (Throwable)ex);
                }
            }
            submenu.sort();
            result.add((JMenuItem)submenu);
            submenu = new BaseMenu("Compare output");
            submenu.setEnabled(indices.length >= 2);
            if (indices.length >= 2) {
                for (Class cls : classes = ClassLister.getSingleton().getClasses(AbstractOutputGenerator.class)) {
                    try {
                        generator = (AbstractOutputGenerator)((Object)cls.newInstance());
                        menuitem = new JMenuItem(generator.getTitle());
                        menuitem.setEnabled(generator.canGenerateOutput((AbstractResultItem)((Object)this.getEntry(indices[0]))));
                        menuitem.addActionListener(ae -> this.compareOutput(generator, indices));
                        submenu.add(menuitem);
                    }
                    catch (Exception ex) {
                        ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate output generator: " + cls.getName(), (Throwable)ex);
                    }
                }
                submenu.sort();
            }
            result.add((JMenuItem)submenu);
            menuitem = new JMenuItem("Export output...");
            menuitem.setEnabled(indices.length == 1 && ((ResultItem)((Object)this.getEntry(indices[0]))).getTabbedPane().getTabCount() > 0);
            menuitem.addActionListener(ae -> ((ResultItem)((Object)((Object)this.getEntry(indices[0])))).getTabbedPane().export());
            result.add(menuitem);
            adams.gui.tools.wekainvestigator.history.AbstractHistoryPopupMenuItem.updatePopupMenu(this, this.m_Owner, indices, (JPopupMenu)result, AbstractHistoryPopupMenuItem.class);
            return result;
        }
    }
}

