/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.Index;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithEditableDataTable;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.ScatterPaintletCross;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.Coordinates;
import adams.gui.visualization.stats.scatterplot.ScatterPlot;
import adams.ml.data.InstancesView;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScatterPlotTab
extends AbstractInvestigatorTabWithEditableDataTable
implements ChangeListener {
    private static final long serialVersionUID = -94945456385486233L;
    protected Map<DataContainer, ScatterPlot> m_PlotCache;
    protected Map<DataContainer, Date> m_TimestampCache;
    protected Integer m_MaxColWidth;
    protected ScatterPlot m_CurrentPanel;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PlotCache = new HashMap<DataContainer, ScatterPlot>();
        this.m_TimestampCache = new HashMap<DataContainer, Date>();
        this.m_MaxColWidth = null;
        this.m_CurrentPanel = null;
    }

    @Override
    public String getTitle() {
        return "Scatter plot";
    }

    @Override
    public String getTabIcon() {
        return "scatterplot2.png";
    }

    @Override
    protected int getDataTableListSelectionMode() {
        return 0;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        super.dataChanged(e);
        HashSet<DataContainer> cached = new HashSet<DataContainer>(this.m_PlotCache.keySet());
        HashSet<DataContainer> current = new HashSet<DataContainer>();
        for (DataContainer cont : this.getOwner().getData()) {
            current.add(cont);
        }
        cached.removeAll(current);
        for (DataContainer cont : cached) {
            this.m_PlotCache.remove(cont);
            this.m_TimestampCache.remove(cont);
        }
        for (DataContainer cont : current) {
            if (!this.m_TimestampCache.containsKey(cont) || cont.lastUpdated().equals(this.m_TimestampCache.get(cont))) continue;
            this.m_PlotCache.remove(cont);
            this.m_TimestampCache.remove(cont);
        }
        if (e.getType() == 4) {
            for (Object row : (Object)e.getRows()) {
                DataContainer con = this.getData().get((int)row);
                this.m_PlotCache.remove(con);
                this.m_TimestampCache.remove(con);
            }
        }
        this.displayData();
    }

    @Override
    protected void dataTableSelectionChanged() {
        super.dataTableSelectionChanged();
        this.displayData();
    }

    protected void displayData() {
        if (this.m_MaxColWidth == null) {
            this.m_MaxColWidth = InvestigatorPanel.getProperties().getInteger("Data.MaxColWidth", Integer.valueOf(100));
        }
        if (this.m_Table.getRowCount() > 0 && this.m_Table.getSelectedRow() > -1) {
            int index = this.m_Table.getSelectedRow();
            DataContainer cont = this.getData().get(index);
            if (this.m_PlotCache.containsKey(cont)) {
                this.m_CurrentPanel = this.m_PlotCache.get(cont);
            } else {
                InstancesView view = new InstancesView(cont.getData());
                this.m_CurrentPanel = new ScatterPlot();
                this.m_CurrentPanel.setData((SpreadSheet)view);
                this.m_CurrentPanel.setXIndex(new Index("1"));
                this.m_CurrentPanel.setYIndex(new Index("2"));
                this.m_CurrentPanel.setPaintlet((AbstractScatterPlotPaintlet)new ScatterPaintletCross());
                this.m_CurrentPanel.setOverlays(new AbstractScatterPlotOverlay[]{new Coordinates()});
                this.m_CurrentPanel.reset();
                this.m_PlotCache.put(cont, this.m_CurrentPanel);
                this.m_TimestampCache.put(cont, new Date(cont.lastUpdated().getTime()));
            }
            this.m_PanelData.removeAll();
            this.m_PanelData.add((Component)this.m_CurrentPanel, "Center");
            if (this.m_SplitPane.isBottomComponentHidden()) {
                this.m_SplitPane.setDividerLocation(this.m_DefaultDataTableHeight);
                this.m_SplitPane.setBottomComponentHidden(false);
            }
        } else {
            this.m_PanelData.removeAll();
            this.m_SplitPane.setBottomComponentHidden(true);
        }
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.getSelectedRows().length > 0) {
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 4, this.getSelectedRows()[0]));
        } else {
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1));
        }
    }
}

