/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.attseltab.evaluation;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.gui.core.BaseComboBox;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.AttributeSelectionTab;
import adams.gui.tools.wekainvestigator.tab.attseltab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.attseltab.evaluation.AbstractAttributeSelectionEvaluation;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.classifiers.DefaultCrossValidationFoldGenerator;
import weka.core.Capabilities;
import weka.core.Instances;

public class CrossValidation
extends AbstractAttributeSelectionEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_FOLDS = "folds";
    public static final String KEY_SEED = "seed";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected JSpinner m_SpinnerFolds;
    protected NumberTextField m_TextSeed;

    public String globalInfo() {
        return "Cross-validates the attribute selection on the selected dataset.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = CrossValidation.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_SpinnerFolds = new JSpinner();
        ((SpinnerNumberModel)this.m_SpinnerFolds.getModel()).setMinimum(Integer.valueOf(2));
        ((SpinnerNumberModel)this.m_SpinnerFolds.getModel()).setStepSize(1);
        this.m_SpinnerFolds.setValue(props.getInteger("AttributeSelection.NumFolds", Integer.valueOf(10)));
        this.m_SpinnerFolds.setToolTipText("The number of folds to use (>= 2)");
        this.m_SpinnerFolds.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Folds", (Component)this.m_SpinnerFolds);
        this.m_TextSeed = new NumberTextField(NumberTextField.Type.INTEGER, "" + props.getInteger("AttributeSelection.Seed", Integer.valueOf(1)));
        this.m_TextSeed.setToolTipText("The seed value for randomizing the data");
        this.m_TextSeed.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CrossValidation.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Seed", (Component)this.m_TextSeed);
    }

    @Override
    public String getName() {
        return "Cross-validation";
    }

    @Override
    public String canEvaluate(ASEvaluation evaluator, ASSearch search) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        if (!Utils.isInteger((String)this.m_TextSeed.getText())) {
            return "Seed value is not an integer!";
        }
        Instances data = ((AttributeSelectionTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Capabilities caps = evaluator.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Evaluator cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Evaluator cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(ASEvaluation evaluator, ASSearch search) throws Exception {
        Instances data = ((AttributeSelectionTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(evaluator, search, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(ASEvaluation evaluator, ASSearch search, ResultItem item) throws Exception {
        String msg = this.canEvaluate(evaluator, search);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot perform attribute selection!\n" + msg);
        }
        DataContainer dataCont = ((AttributeSelectionTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        int seed = this.m_TextSeed.getValue().intValue();
        int folds = ((Number)this.m_SpinnerFolds.getValue()).intValue();
        ASEvaluation eval = (ASEvaluation)OptionUtils.shallowCopy((Object)evaluator);
        ASSearch srch = (ASSearch)OptionUtils.shallowCopy((Object)search);
        MetaData runInfo = new MetaData();
        runInfo.add("Evaluator", (Object)OptionUtils.getCommandLine((Object)evaluator));
        runInfo.add("Search", (Object)OptionUtils.getCommandLine((Object)search));
        runInfo.add("Seed", (Object)seed);
        runInfo.add("Folds", (Object)folds);
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        if (data.classIndex() > -1) {
            runInfo.add("Class attribute", (Object)data.classAttribute().name());
        }
        AttributeSelection attsel = new AttributeSelection();
        attsel.setSearch(srch);
        attsel.setEvaluator(eval);
        attsel.setSeed(seed);
        attsel.setFolds(folds);
        DefaultCrossValidationFoldGenerator generator = new DefaultCrossValidationFoldGenerator(data, folds, seed, true);
        int current = 0;
        while (generator.hasNext()) {
            ((AttributeSelectionTab)this.getOwner()).logMessage("Fold " + ++current + "/" + folds + ": '" + data.relationName() + "' using " + OptionUtils.getCommandLine((Object)eval) + " and " + OptionUtils.getCommandLine((Object)srch));
            WekaTrainTestSetContainer cont = generator.next();
            Instances train = (Instances)cont.getValue("Train");
            attsel.selectAttributesCVSplit(train);
        }
        item.update(attsel, folds, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((AttributeSelectionTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((AttributeSelectionTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((AttributeSelectionTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        ((AttributeSelectionTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_FOLDS, this.m_SpinnerFolds.getValue());
            result.put(KEY_SEED, this.m_TextSeed.getValue().intValue());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_FOLDS)) {
            this.m_SpinnerFolds.setValue(data.get(KEY_FOLDS));
        }
        if (data.containsKey(KEY_SEED)) {
            this.m_TextSeed.setValue((Number)((Number)data.get(KEY_SEED)).intValue());
        }
    }
}

