/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab;

import adams.core.MessageCollection;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.SpreadSheetMerge;
import adams.flow.transformer.WekaPredictionsToSpreadSheet;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import weka.classifiers.Evaluation;

public class PredictionHelper {
    public static SpreadSheet toSpreadSheet(LoggingSupporter logger, MessageCollection errors, ResultItem item, boolean addAdditionalAttributes, boolean showError) {
        return PredictionHelper.toSpreadSheet(logger, errors, item, addAdditionalAttributes, false, false, false, showError, false);
    }

    public static SpreadSheet toSpreadSheet(LoggingSupporter logger, MessageCollection errors, Evaluation eval, int[] originalIndices, SpreadSheet additionalAttributes, boolean showError) {
        return PredictionHelper.toSpreadSheet(logger, errors, eval, originalIndices, additionalAttributes, false, false, false, showError, false);
    }

    public static SpreadSheet toSpreadSheet(LoggingSupporter logger, MessageCollection errors, ResultItem item, boolean addAdditionalAttributes, boolean addLabelIndex, boolean showDistribution, boolean showProbability, boolean showError, boolean showWeight) {
        return PredictionHelper.toSpreadSheet(logger, errors, item.getEvaluation(), item.getOriginalIndices(), addAdditionalAttributes ? item.getAdditionalAttributes() : null, addLabelIndex, showDistribution, showProbability, showError, showWeight);
    }

    public static SpreadSheet toSpreadSheet(LoggingSupporter logger, MessageCollection errors, Evaluation eval, int[] originalIndices, SpreadSheet additionalAttributes, boolean addLabelIndex, boolean showDistribution, boolean showProbability, boolean showError, boolean showWeight) {
        WekaEvaluationContainer cont = new WekaEvaluationContainer(eval);
        if (originalIndices != null) {
            cont.setValue("Original indices", originalIndices);
        }
        WekaPredictionsToSpreadSheet p2s = new WekaPredictionsToSpreadSheet();
        p2s.setAddLabelIndex(addLabelIndex);
        p2s.setShowDistribution(showDistribution);
        p2s.setShowProbability(showProbability);
        p2s.setShowError(showError);
        p2s.setShowWeight(showWeight);
        p2s.setUseOriginalIndices(true);
        p2s.input(new Token((Object)cont));
        try {
            p2s.execute();
        }
        catch (Exception e) {
            String msg = "Failed to assemble predictions!";
            if (logger != null) {
                LoggingHelper.handleException((LoggingSupporter)logger, (String)msg, (Throwable)e);
            }
            errors.add(msg, (Throwable)e);
            return null;
        }
        Token token = p2s.output();
        if (additionalAttributes != null) {
            SpreadSheet sheet = (SpreadSheet)token.getPayload();
            SpreadSheetMerge merge = new SpreadSheetMerge();
            token = new Token((Object)new SpreadSheet[]{sheet, additionalAttributes});
            merge.input(token);
            String msg = merge.execute();
            if (msg != null) {
                msg = "Failed to merge predictions and additional attributes!\n" + msg;
                if (logger != null) {
                    logger.getLogger().severe(msg);
                }
                errors.add(msg);
                token = new Token((Object)sheet);
            } else {
                token = merge.output();
            }
        }
        return (SpreadSheet)token.getPayload();
    }
}

