/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import weka.core.Drawable;

public class GraphSource
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;

    public String globalInfo() {
        return "Outputs the graph source (dot or XML BIF).";
    }

    @Override
    public String getTitle() {
        return "Graph source";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasModel() && item.getModel() instanceof Drawable;
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        if (!item.hasModel()) {
            errors.add("No model available!");
            return null;
        }
        try {
            BaseTextArea text = new BaseTextArea();
            text.setEditable(false);
            text.setTextFont(Fonts.getMonospacedFont());
            text.setText(((Drawable)item.getModel()).graph());
            text.setCaretPosition(0);
            return new TextualContentPanel((JTextComponent)text, true);
        }
        catch (Exception e) {
            errors.add("Failed to obtain graph source!", (Throwable)e);
            return null;
        }
    }
}

