/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.SimplePlot;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.PredictionHelper;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGeneratorWithSeparateFoldsSupport;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.CustomColorProvider;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Color;
import java.util.HashMap;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;

public class PredictionTrend
extends AbstractOutputGeneratorWithSeparateFoldsSupport<ComponentContentPanel> {
    private static final long serialVersionUID = -6829245659118360739L;
    protected XYSequencePaintlet m_Paintlet;
    protected ColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Generates a 'prediction trend' for classifier errors: sorts the predictions on the actual value and plots actual and predicted side-by-side.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("paintlet", "paintlet", (Object)this.getDefaultPaintlet());
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)this.getDefaultColorProvider());
    }

    protected XYSequencePaintlet getDefaultPaintlet() {
        LinePaintlet result = new LinePaintlet();
        result.setPaintAll(true);
        return result;
    }

    public void setPaintlet(XYSequencePaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public XYSequencePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for the plot.";
    }

    protected ColorProvider getDefaultColorProvider() {
        CustomColorProvider result = new CustomColorProvider();
        result.setColors(new Color[]{Color.BLUE, Color.RED});
        return result;
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for the plot colors.";
    }

    @Override
    public String getTitle() {
        return "Prediction trend";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().getHeader().classAttribute().isNumeric() && item.getEvaluation().predictions() != null;
    }

    @Override
    protected ComponentContentPanel createOutput(Evaluation eval, MessageCollection errors) {
        SpreadSheet sheet = PredictionHelper.toSpreadSheet((LoggingSupporter)this, errors, eval, null, null, false, false, false, false, false);
        if (sheet == null) {
            if (errors.isEmpty()) {
                errors.add("Failed to generate predictions!");
            }
            return null;
        }
        sheet.sort(0, true);
        SimplePlot plot = new SimplePlot();
        plot.setTitle("Trend");
        plot.setPaintlet((XYSequencePaintlet)this.m_Paintlet.shallowCopy());
        plot.setColorProvider((ColorProvider)this.m_ColorProvider.shallowCopy());
        plot.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        plot.getAxisX().setLabel("index");
        plot.getAxisY().setLabel("class value");
        AbstractDisplayPanel panel = plot.createDisplayPanel(null);
        SequencePlotterContainer[] conts = new SequencePlotterContainer[2];
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            conts[0] = new SequencePlotterContainer("actual", (Comparable)Double.valueOf((double)i + 1.0), (Comparable)row.getCell(0).toDouble());
            conts[1] = new SequencePlotterContainer("predicted", (Comparable)Double.valueOf((double)i + 1.0), (Comparable)row.getCell(1).toDouble());
            for (SequencePlotterContainer cont : conts) {
                if (sheet.getColumnCount() > 2) {
                    cont.setValue("MetaData", new HashMap());
                    for (int n = 2; n < sheet.getColumnCount(); ++n) {
                        cont.addMetaData(sheet.getColumnName(n), row.getCell(n).getNative());
                    }
                }
                panel.display(new Token((Object)cont));
            }
        }
        panel.wrapUp();
        return new ComponentContentPanel((JComponent)panel, false);
    }
}

