/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output.perfold;

import adams.core.MessageCollection;
import adams.core.logging.LoggingLevel;
import adams.data.spreadsheet.MetaData;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.perfold.AbstractPerFoldPopupMenuItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.perfold.PerFoldMultiPagePane;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class SubRangeEvaluation
extends AbstractPerFoldPopupMenuItem {
    @Override
    public String getCategory() {
        return "Evaluation";
    }

    @Override
    public String getTitle() {
        return "Sub-range evaluation...";
    }

    protected double[] queryUser(PerFoldMultiPagePane pane, ResultItem item) {
        Evaluation eval = item.getEvaluation();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Prediction pred : eval.predictions()) {
            min = Math.min(min, pred.actual());
            max = Math.max(max, pred.actual());
        }
        ParameterPanel params = new ParameterPanel();
        NumberTextField textMin = new NumberTextField(NumberTextField.Type.DOUBLE);
        textMin.setValue((Number)min);
        params.addParameter("Minimum", (Component)textMin);
        NumberTextField textMax = new NumberTextField(NumberTextField.Type.DOUBLE);
        textMax.setValue((Number)max);
        params.addParameter("Maximum", (Component)textMax);
        ApprovalDialog dialog = GUIHelper.getParentDialog((Container)((Object)pane)) != null ? new ApprovalDialog(GUIHelper.getParentDialog((Container)((Object)pane)), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(GUIHelper.getParentFrame((Container)((Object)pane)), true);
        dialog.setTitle("Sub-range evaluation");
        dialog.getContentPane().add((Component)params, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)pane));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        min = textMin.getValue().doubleValue();
        if (min >= (max = textMax.getValue().doubleValue())) {
            GUIHelper.showErrorMessage((Component)((Object)pane), (String)("Minimum must be smaller than maximum!\nmin: " + min + "\nmax: " + max));
            return null;
        }
        return new double[]{min, max};
    }

    protected MetaData addSubRangeInfo(MetaData info, double[] range) {
        MetaData result = info.getClone();
        String prefix = "Sub-range evaluation";
        int count = 0;
        boolean added = false;
        do {
            String key;
            if (!result.has(key = count == 0 ? prefix : prefix + " (" + (count + 1) + ")")) {
                result.add(key, (Object)("[" + range[0] + ";" + range[1] + "]"));
                added = true;
            }
            ++count;
        } while (!added);
        return result;
    }

    protected void createSubEvaluation(PerFoldMultiPagePane pane, ResultItem item, Evaluation eval, int fold, double[] range) {
        try {
            Evaluation evalFull = eval;
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("Prediction"));
            Instances data = new Instances("[" + range[0] + ";" + range[1] + "]-" + evalFull.getHeader().relationName(), atts, evalFull.predictions().size());
            data.setClassIndex(0);
            ArrayList predsFull = evalFull.predictions();
            for (Prediction pred : predsFull) {
                DenseInstance inst = new DenseInstance(1.0, new double[]{pred.actual()});
                data.add((Instance)inst);
            }
            Evaluation evalSub = new Evaluation(data);
            for (int i = 0; i < predsFull.size(); ++i) {
                Prediction prd = (Prediction)predsFull.get(i);
                if (!(prd.actual() >= range[0]) || !(prd.actual() <= range[1])) continue;
                evalSub.evaluateModelOnceAndRecordPrediction(new double[]{prd.predicted()}, data.instance(i));
            }
            MetaData runInfoSub = this.addSubRangeInfo(item.getRunInformation(), range);
            ResultItem itemSub = new ResultItem(item.getTemplate(), new Instances(data, 0));
            itemSub.update(evalSub, null, runInfoSub);
            MessageCollection errors = new MessageCollection();
            JComponent comp = this.m_OutputGenerator.createOutput(itemSub, errors);
            String title = fold == 0 ? "Full" : "Fold " + fold;
            title = title + " [" + range[0] + ";" + range[1] + "]";
            pane.addPage(title, comp, -1);
            if (!errors.isEmpty()) {
                throw new Exception("Failed to generate output:\n" + errors);
            }
            pane.setSelectedIndex(pane.getPageCount() - 1);
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)LoggingLevel.SEVERE, "Failed to generate sub-range evaluation!", (Throwable)e);
        }
    }

    protected void createSubEvaluations(PerFoldMultiPagePane pane, ResultItem item, Evaluation[] evals, int[] folds, double[] range) {
        for (int i = 0; i < evals.length; ++i) {
            this.createSubEvaluation(pane, item, evals[i], folds[i], range);
        }
    }

    @Override
    public JMenuItem createMenuItem(PerFoldMultiPagePane pane, int[] indices) {
        ResultItem item = pane.getItem();
        TIntArrayList validIndices = new TIntArrayList();
        ArrayList<Evaluation> validEvals = new ArrayList<Evaluation>();
        for (int index : indices) {
            boolean valid;
            if (!pane.getPageContainerAt(index).getMetaData().containsKey("Fold")) continue;
            int fold = (Integer)pane.getPageContainerAt(index).getMetaData().get("Fold");
            Evaluation eval = null;
            if (fold < 0) continue;
            if (fold == 0) {
                boolean bl = valid = item.hasEvaluation() && item.getEvaluation().getHeader().classAttribute().isNumeric() && item.getEvaluation().predictions() != null;
                if (valid) {
                    eval = item.getEvaluation();
                }
            } else {
                boolean bl = valid = item.hasFoldEvaluations() && item.getFoldEvaluations()[fold - 1].getHeader().classAttribute().isNumeric() && item.getFoldEvaluations()[fold - 1].predictions() != null;
                if (valid) {
                    eval = item.getFoldEvaluations()[fold - 1];
                }
            }
            if (!valid) continue;
            validIndices.add(fold);
            validEvals.add(eval);
        }
        JMenuItem result = new JMenuItem(this.getTitle());
        result.setEnabled(validIndices.size() > 0);
        if (validIndices.size() == 0) {
            return result;
        }
        result.addActionListener(arg_0 -> this.lambda$createMenuItem$0(pane, item, validEvals, (TIntList)validIndices, arg_0));
        return result;
    }

    private /* synthetic */ void lambda$createMenuItem$0(PerFoldMultiPagePane pane, ResultItem item, List validEvals, TIntList validIndices, ActionEvent e) {
        double[] range = this.queryUser(pane, item);
        if (range == null) {
            return;
        }
        this.createSubEvaluations(pane, item, validEvals.toArray(new Evaluation[0]), validIndices.toArray(), range);
    }
}

