/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction;

import adams.gui.core.GUIHelper;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction.AbstractSelectedAttributesAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RenameAttribute;

public class Rename
extends AbstractSelectedAttributesAction {
    private static final long serialVersionUID = -217537095007987947L;

    public Rename() {
        this.setName("Rename");
        this.setIcon("rename.png");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        DataContainer cont = this.getSelectedData()[0];
        Instances data = cont.getData();
        int attIndex = this.getOwner().getAttributeSelectionPanel().getSelectedRows()[0];
        String nameOld = data.attribute(attIndex).name();
        String nameNew = GUIHelper.showInputDialog((Component)((Object)this.getOwner()), (String)"Please enter new attribute name", (String)nameOld);
        if (nameNew == null || nameNew.equals(nameOld)) {
            return;
        }
        cont.addUndoPoint("Renaming attribute #" + (attIndex + 1) + " '" + nameOld + "' to '" + nameNew + "'");
        RenameAttribute rename = new RenameAttribute();
        rename.setAttributeIndices("" + (attIndex + 1));
        rename.setFind("([\\s\\S]+)");
        rename.setReplace(nameNew);
        try {
            rename.setInputFormat(data);
            Instances filtered = Filter.useFilter((Instances)data, (Filter)rename);
            cont.setData(filtered);
            WekaInvestigatorDataEvent event = new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, new int[]{this.getSelectedRows()[0]});
            this.getOwner().fireDataChange(event);
        }
        catch (Exception ex) {
            this.logError("Failed to rename attribute #" + (attIndex + 1) + " '" + nameOld + "' to '" + nameNew + "'", ex, "Rename failed");
        }
    }

    @Override
    public void update() {
        this.setEnabled(this.getOwner() != null && !this.isBusy() && this.getSelectedRows().length == 1 && this.getOwner().getAttributeSelectionPanel().getSelectedRows().length == 1 && this.m_Owner.canStartExecution());
    }
}

