/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.setup.weka;

import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.tools.wekamultiexperimenter.setup.weka.AbstractOutputPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.experiment.DatabaseResultListener;
import weka.experiment.DatabaseUtils;
import weka.experiment.ResultListener;

public class JdbcOutputPanel
extends AbstractOutputPanel {
    private static final long serialVersionUID = 3142999120128854278L;
    protected BaseTextField m_TextURL;
    protected BaseButton m_ButtonCredentials;
    protected BaseTextField m_TextUser;
    protected JPasswordField m_TextPassword;
    protected BaseCheckBox m_CheckBoxShowPassword;

    protected void initGUI() {
        DatabaseUtils dbutils;
        super.initGUI();
        ParameterPanel panel = new ParameterPanel();
        try {
            dbutils = new DatabaseUtils();
        }
        catch (Exception e) {
            this.logError("Failed to instantiate " + DatabaseUtils.class.getName(), "Initializing database");
            dbutils = null;
        }
        this.m_TextURL = new BaseTextField(40);
        this.m_TextURL.setText(dbutils == null ? "" : dbutils.getDatabaseURL());
        this.m_ButtonCredentials = new BaseButton("...");
        this.m_ButtonCredentials.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdbcOutputPanel.this.showCredentials();
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.m_TextURL, "Center");
        panel2.add((Component)this.m_ButtonCredentials, "East");
        panel.addParameter("URL", (Component)panel2);
        this.m_TextUser = new BaseTextField(20);
        this.m_TextUser.setText(dbutils == null ? "" : dbutils.getUsername());
        this.m_TextPassword = new JPasswordField(20);
        this.m_TextPassword.setText(dbutils == null ? "" : dbutils.getPassword());
        this.m_TextPassword.setEchoChar('*');
        this.m_CheckBoxShowPassword = new BaseCheckBox();
        this.m_CheckBoxShowPassword.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!JdbcOutputPanel.this.m_CheckBoxShowPassword.isSelected()) {
                    JdbcOutputPanel.this.m_TextPassword.setEchoChar('*');
                } else {
                    JdbcOutputPanel.this.m_TextPassword.setEchoChar('\u0000');
                }
            }
        });
        this.add((Component)panel, "Center");
    }

    protected void showCredentials() {
        ParameterPanel panel = new ParameterPanel();
        panel.addParameter("User", (Component)this.m_TextUser);
        panel.addParameter("Password", (Component)this.m_TextPassword);
        panel.addParameter("Show password", (Component)this.m_CheckBoxShowPassword);
        String user = this.m_TextUser.getText();
        String pw = this.m_TextPassword.getText();
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getParentFrame(), true);
        dialog.setTitle("Database credentials");
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setDiscardVisible(false);
        dialog.setApproveVisible(true);
        dialog.setCancelVisible(true);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            this.m_TextUser.setText(user);
            this.m_TextPassword.setText(pw);
        }
    }

    @Override
    public String getOutputName() {
        return "JDBC";
    }

    @Override
    public boolean handlesResultListener(ResultListener listener) {
        return listener.getClass() == DatabaseResultListener.class;
    }

    @Override
    public void setResultListener(ResultListener value) {
        this.m_TextURL.setText(((DatabaseResultListener)value).getDatabaseURL());
        this.m_TextUser.setText(((DatabaseResultListener)value).getUsername());
        this.m_TextPassword.setText(((DatabaseResultListener)value).getPassword());
    }

    @Override
    public ResultListener getResultListener() {
        DatabaseResultListener result;
        try {
            result = new DatabaseResultListener();
            result.setDatabaseURL(this.m_TextURL.getText());
            result.setUsername(this.m_TextUser.getText());
            result.setPassword(this.m_TextPassword.getText());
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }
}

