/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseScrollPane;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import adams.gui.visualization.debug.objectrenderer.PlainTextRenderer;
import adams.gui.visualization.debug.objectrenderer.SpreadSheetRenderer;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.InstancesTableModel;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import nz.ac.waikato.cms.locator.ClassLocator;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;

public class WekaInstancesRenderer
extends AbstractObjectRenderer {
    private static final long serialVersionUID = -3528006886476495175L;
    public static final int MAX_ROWS = 100;
    protected InstancesTable m_LastTable;

    public boolean handles(Class cls) {
        return ClassLocator.isSubclass(Instances.class, (Class)cls) || ClassLocator.hasInterface(Instance.class, (Class)cls);
    }

    public boolean canRenderCached(Object obj, JPanel panel) {
        return this.m_LastTable != null && (obj instanceof Instances && ((Instances)obj).numInstances() > 0 || obj instanceof Instance && ((Instance)obj).dataset() != null);
    }

    protected String doRenderCached(Object obj, JPanel panel) {
        Instances data;
        if (obj instanceof Instances) {
            data = (Instances)obj;
        } else {
            Instance inst = (Instance)obj;
            data = new Instances(inst.dataset(), 0);
            data.add((Instance)inst.copy());
        }
        this.m_LastTable.setModel(new InstancesTableModel(data));
        BaseScrollPane scrollPane = new BaseScrollPane((Component)((Object)this.m_LastTable));
        panel.add((Component)scrollPane, "Center");
        return null;
    }

    protected String doRender(Object obj, JPanel panel) {
        if (obj instanceof Instances) {
            Instances data = (Instances)obj;
            if (data.numInstances() == 0) {
                DefaultSpreadSheet sheet = new DefaultSpreadSheet();
                HeaderRow row = sheet.getHeaderRow();
                row.addCell("I").setContentAsString("Index");
                row.addCell("N").setContentAsString("Name");
                row.addCell("T").setContentAsString("Type");
                row.addCell("C").setContentAsString("Class");
                for (int i = 0; i < data.numAttributes(); ++i) {
                    row = sheet.addRow();
                    row.addCell("I").setContent(Integer.valueOf(i + 1));
                    row.addCell("N").setContentAsString(data.attribute(i).name());
                    row.addCell("T").setContentAsString(Attribute.typeToString((Attribute)data.attribute(i)));
                    row.addCell("C").setContent(i == data.classIndex() ? "true" : "");
                }
                SpreadSheetRenderer sprenderer = new SpreadSheetRenderer();
                sprenderer.render((Object)sheet, panel);
            } else if (data.numInstances() > 100) {
                InstancesView view = new InstancesView(data, 0, 100);
                InstancesTableModel model = new InstancesTableModel(view);
                model.setShowAttributeIndex(true);
                InstancesTable table = new InstancesTable(model);
                BaseScrollPane scrollPane = new BaseScrollPane((Component)((Object)table));
                panel.add((Component)scrollPane, "Center");
                JPanel panelButton = new JPanel(new FlowLayout(0));
                panel.add((Component)panelButton, "South");
                BaseButton buttonAll = new BaseButton("Show all " + data.numInstances() + " rows");
                buttonAll.addActionListener(e -> {
                    table.setInstances(data);
                    panelButton.setVisible(false);
                    this.m_LastTable = table;
                });
                panelButton.add((Component)buttonAll);
            } else {
                InstancesTableModel model = new InstancesTableModel(data);
                model.setShowAttributeIndex(true);
                InstancesTable table = new InstancesTable(model);
                BaseScrollPane scrollPane = new BaseScrollPane((Component)((Object)table));
                panel.add((Component)scrollPane, "Center");
                this.m_LastTable = table;
            }
        } else {
            Instance inst = (Instance)obj;
            if (inst.dataset() != null) {
                Instances data = new Instances(inst.dataset(), 0);
                data.add((Instance)inst.copy());
                InstancesTable table = new InstancesTable(data);
                BaseScrollPane scrollPane = new BaseScrollPane((Component)((Object)table));
                panel.add((Component)scrollPane, "Center");
                this.m_LastTable = table;
            } else {
                PlainTextRenderer plain = new PlainTextRenderer();
                plain.render(obj, panel);
            }
        }
        return null;
    }
}

