/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.core.Index;
import adams.core.Range;
import adams.gui.chooser.DatasetFileChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.visualization.instance.InstanceTable;
import adams.gui.visualization.instance.InstanceTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import weka.core.Instances;

public class LoadDatasetDialog
extends BaseDialog {
    private static final long serialVersionUID = 3881690262061461134L;
    public static final String NO_CLASS = "-no class-";
    public static final String NO_SORTING = "-no sorting-";
    public static final String NO_ID = "-no ID-";
    protected LoadDatasetDialog m_Self;
    protected DatasetFileChooserPanel m_FilePanel;
    protected BaseButton m_ButtonReload;
    protected InstanceTable m_TableData;
    protected BaseButton m_ButtonLoad;
    protected BaseButton m_ButtonClose;
    protected SearchPanel m_SearchPanel;
    protected BaseComboBox m_ComboBoxClass;
    protected DefaultComboBoxModel m_ComboBoxClassModel;
    protected BaseComboBox m_ComboBoxSorting;
    protected DefaultComboBoxModel m_ComboBoxSortingModel;
    protected BaseComboBox m_ComboBoxID;
    protected DefaultComboBoxModel m_ComboBoxIDModel;
    protected JList m_ListAdditionalAttributes;
    protected DefaultListModel m_ListAdditionalAttributesModel;
    protected BaseTextField m_TextAttributeRange;
    protected Range m_DefaultAttributeRange;
    protected BaseCheckBox m_CheckBoxIncludeNumericAttributes;
    protected BaseCheckBox m_CheckBoxIncludeDateAttributes;
    protected BaseCheckBox m_CheckBoxIncludeNominalAttributes;
    protected BaseCheckBox m_CheckBoxIncludeStringAttributes;
    protected BaseCheckBox m_CheckBoxIncludeRelationalAttributes;
    protected Instances m_Instances;
    protected int[] m_Indices;
    protected BaseTabbedPane m_TabbedPane;
    protected Index m_DefaultClassIndex;
    protected Index m_DefaultIDIndex;
    protected Index m_DefaultSortIndex;
    protected boolean m_DefaultIncludeNumericAttributes;
    protected boolean m_DefaultIncludeDateAttributes;
    protected boolean m_DefaultIncludeNominalAttributes;
    protected boolean m_DefaultIncludeStringAttributes;
    protected boolean m_DefaultIncludeRelationalAttributes;
    protected ChangeListener m_AcceptListener;
    protected ChangeListener m_CancelListener;

    public LoadDatasetDialog(Dialog owner) {
        this(owner, "Load dataset");
    }

    public LoadDatasetDialog(Dialog owner, String title) {
        super(owner, title, Dialog.ModalityType.MODELESS);
    }

    public LoadDatasetDialog(Frame owner) {
        this(owner, "Load dataset");
    }

    public LoadDatasetDialog(Frame owner, String title) {
        super(owner, title, false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_Instances = null;
        this.m_ComboBoxClassModel = new DefaultComboBoxModel();
        this.m_ComboBoxClassModel.addElement(NO_CLASS);
        this.m_ComboBoxSortingModel = new DefaultComboBoxModel();
        this.m_ComboBoxSortingModel.addElement(NO_SORTING);
        this.m_ComboBoxIDModel = new DefaultComboBoxModel();
        this.m_ComboBoxIDModel.addElement(NO_ID);
        this.m_ListAdditionalAttributesModel = new DefaultListModel();
        this.m_DefaultClassIndex = new Index();
        this.m_DefaultIDIndex = new Index();
        this.m_DefaultSortIndex = new Index();
        this.m_DefaultIncludeNumericAttributes = false;
        this.m_DefaultIncludeDateAttributes = false;
        this.m_DefaultIncludeNominalAttributes = false;
        this.m_DefaultIncludeStringAttributes = false;
        this.m_DefaultIncludeRelationalAttributes = false;
        this.m_DefaultAttributeRange = new Range("first-last");
        this.m_AcceptListener = null;
        this.m_CancelListener = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)contentPanel, "Center");
        JPanel panelAll = new JPanel(new BorderLayout(5, 5));
        contentPanel.add((Component)panelAll, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panelAll.add((Component)panel, "North");
        this.m_FilePanel = new DatasetFileChooserPanel();
        this.m_FilePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.m_FilePanel.setPrefix("File");
        this.m_FilePanel.addChangeListener(e -> {
            this.m_ButtonLoad.setEnabled(this.getFilename().length() > 0);
            if (this.m_ButtonLoad.isEnabled()) {
                this.loadFile(false);
            }
            this.m_ButtonReload.setEnabled(this.m_ButtonLoad.isEnabled());
        });
        panel.add((Component)((Object)this.m_FilePanel), "Center");
        this.m_ButtonReload = new BaseButton((Icon)GUIHelper.getIcon((String)"refresh.gif"));
        this.m_ButtonReload.setEnabled(false);
        this.m_ButtonReload.addActionListener(e -> this.loadFile(true));
        JPanel panelAttributes = new JPanel(new BorderLayout());
        panelAttributes.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panelAttributes.add((Component)this.m_ButtonReload, "Center");
        panel.add((Component)panelAttributes, "East");
        this.m_TabbedPane = new BaseTabbedPane();
        panelAll.add((Component)this.m_TabbedPane, "Center");
        JPanel panelInstances = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Instances", (Component)panelInstances);
        this.m_TableData = new InstanceTable(null);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        panel.add((Component)new BaseScrollPane((Component)((Object)this.m_TableData)), "Center");
        panelInstances.add((Component)panel, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
        this.m_SearchPanel.setTextColumns(15);
        this.m_SearchPanel.addSearchListener(e -> this.search());
        panel = new JPanel(new FlowLayout(0));
        panel.add((Component)this.m_SearchPanel);
        panel.setBorder(BorderFactory.createEmptyBorder());
        panelInstances.add((Component)panel, "South");
        panelAttributes = new JPanel(new BorderLayout());
        panelAttributes.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TabbedPane.addTab("Attributes", (Component)panelAttributes);
        panel = new JPanel(new GridLayout(14, 1));
        panelAttributes.add((Component)panel, "North");
        this.m_ComboBoxID = new BaseComboBox((ComboBoxModel)this.m_ComboBoxIDModel);
        this.m_ComboBoxID.setSelectedIndex(0);
        this.m_ComboBoxID.setToolTipText("The selected attribute gets used as ID for the instances, rather than the row index");
        JLabel label = new JLabel("ID");
        label.setDisplayedMnemonic('I');
        label.setLabelFor((Component)this.m_ComboBoxID);
        panel.add(label);
        panel.add((Component)this.m_ComboBoxID);
        this.m_ComboBoxClass = new BaseComboBox((ComboBoxModel)this.m_ComboBoxClassModel);
        this.m_ComboBoxClass.setSelectedIndex(0);
        this.m_ComboBoxClass.setToolTipText("The selected attribute gets omitted from display and added to the report instead");
        label = new JLabel("Class");
        label.setDisplayedMnemonic('s');
        label.setLabelFor((Component)this.m_ComboBoxClass);
        panel.add(label);
        panel.add((Component)this.m_ComboBoxClass);
        this.m_TextAttributeRange = new BaseTextField(10);
        this.m_TextAttributeRange.setText("first-last");
        this.m_TextAttributeRange.setToolTipText("For limiting the attributes being displayed");
        label = new JLabel("Attribute range");
        label.setDisplayedMnemonic('r');
        label.setLabelFor((Component)this.m_TextAttributeRange);
        panel.add(label);
        panel.add((Component)this.m_TextAttributeRange);
        label = new JLabel("Attribute types");
        this.m_CheckBoxIncludeNumericAttributes = new BaseCheckBox("Numeric");
        this.m_CheckBoxIncludeDateAttributes = new BaseCheckBox("Date");
        this.m_CheckBoxIncludeNominalAttributes = new BaseCheckBox("Nominal");
        this.m_CheckBoxIncludeStringAttributes = new BaseCheckBox("String");
        this.m_CheckBoxIncludeRelationalAttributes = new BaseCheckBox("Relational");
        panel.add(label);
        panel.add((Component)this.m_CheckBoxIncludeNumericAttributes);
        panel.add((Component)this.m_CheckBoxIncludeDateAttributes);
        panel.add((Component)this.m_CheckBoxIncludeNominalAttributes);
        panel.add((Component)this.m_CheckBoxIncludeNominalAttributes);
        panel.add((Component)this.m_CheckBoxIncludeStringAttributes);
        panel.add((Component)this.m_CheckBoxIncludeRelationalAttributes);
        this.m_ComboBoxSorting = new BaseComboBox((ComboBoxModel)this.m_ComboBoxSortingModel);
        this.m_ComboBoxSorting.setSelectedIndex(0);
        this.m_ComboBoxSorting.setToolTipText("The attribute to sort the data on (ascending)");
        label = new JLabel("Sorting");
        label.setDisplayedMnemonic('r');
        label.setLabelFor((Component)this.m_ComboBoxSorting);
        panel.add(label);
        panel.add((Component)this.m_ComboBoxSorting);
        this.m_ListAdditionalAttributes = new JList(this.m_ListAdditionalAttributesModel);
        this.m_ListAdditionalAttributes.setToolTipText("Additional attribute values to store in the report");
        label = new JLabel("Attributes to store in report");
        label.setLabelFor(this.m_ListAdditionalAttributes);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panelAttributes.add((Component)panel, "Center");
        panel.add((Component)label, "North");
        panel.add((Component)new BaseScrollPane((Component)this.m_ListAdditionalAttributes), "Center");
        panelAll = new JPanel(new FlowLayout(2));
        contentPanel.add((Component)panelAll, "South");
        this.m_ButtonLoad = new BaseButton("OK");
        this.m_ButtonLoad.setMnemonic('O');
        this.m_ButtonLoad.setEnabled(false);
        this.m_ButtonLoad.addActionListener(e -> this.acceptSelection());
        panelAll.add((Component)this.m_ButtonLoad);
        this.m_ButtonClose = new BaseButton("Cancel");
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(e -> this.close());
        panelAll.add((Component)this.m_ButtonClose);
        this.pack();
        this.m_ComboBoxClass.setPreferredSize(new Dimension(150, this.m_ComboBoxClass.getHeight()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public int[] getAdditionalAttributes() {
        return this.m_ListAdditionalAttributes.getSelectedIndices();
    }

    public void setDefaultAttributeRange(String value) {
        this.m_DefaultAttributeRange.setRange(value);
    }

    public String getDefaultAttributeRange() {
        return this.m_DefaultAttributeRange.getRange();
    }

    public Range getCurrentAttributeRange() {
        return new Range(this.m_TextAttributeRange.getText());
    }

    public void setDefaultClassIndex(String value) {
        this.m_DefaultClassIndex.setIndex(value);
    }

    public String getDefaultClassIndex() {
        return this.m_DefaultClassIndex.getIndex();
    }

    public int getCurrentClassIndex() {
        if (this.m_ComboBoxClass.getSelectedIndex() > -1) {
            return this.m_ComboBoxClass.getSelectedIndex() - 1;
        }
        return -1;
    }

    public void setDefaultIDIndex(String value) {
        this.m_DefaultIDIndex.setIndex(value);
    }

    public String getDefaultIDIndex() {
        return this.m_DefaultIDIndex.getIndex();
    }

    public int getCurrentIDIndex() {
        if (this.m_ComboBoxID.getSelectedIndex() > -1) {
            return this.m_ComboBoxID.getSelectedIndex() - 1;
        }
        return -1;
    }

    public void setDefaultSortIndex(String value) {
        this.m_DefaultSortIndex.setIndex(value);
    }

    public String getDefaultSortIndex() {
        return this.m_DefaultSortIndex.getIndex();
    }

    public int getCurrentSortIndex() {
        if (this.m_ComboBoxSorting.getSelectedIndex() > -1) {
            return this.m_ComboBoxSorting.getSelectedIndex() - 1;
        }
        return -1;
    }

    public Instances getDataset() {
        int index;
        Instances result = new Instances(this.m_Instances);
        if (this.m_ComboBoxSorting.getSelectedIndex() > 0) {
            result.sort(this.m_ComboBoxSorting.getSelectedIndex() - 1);
        }
        if ((index = this.m_ComboBoxClass.getSelectedIndex()) > -1) {
            --index;
        }
        result.setClassIndex(index);
        return result;
    }

    public int[] getIndices() {
        return this.m_Indices;
    }

    public void setDefaultIncludeAttributes(int attType, boolean value) {
        switch (attType) {
            case 0: {
                this.m_DefaultIncludeNumericAttributes = value;
                break;
            }
            case 3: {
                this.m_DefaultIncludeDateAttributes = value;
                break;
            }
            case 1: {
                this.m_DefaultIncludeNominalAttributes = value;
                break;
            }
            case 2: {
                this.m_DefaultIncludeStringAttributes = value;
                break;
            }
            case 4: {
                this.m_DefaultIncludeDateAttributes = value;
                break;
            }
            default: {
                System.err.println(((Object)((Object)this)).getClass().getName() + ": unhandled attribute type " + attType);
            }
        }
    }

    public boolean getDefaultInclueAttributes(int attType) {
        switch (attType) {
            case 0: {
                return this.m_DefaultIncludeNumericAttributes;
            }
            case 3: {
                return this.m_DefaultIncludeDateAttributes;
            }
            case 1: {
                return this.m_DefaultIncludeNominalAttributes;
            }
            case 2: {
                return this.m_DefaultIncludeStringAttributes;
            }
            case 4: {
                return this.m_DefaultIncludeDateAttributes;
            }
        }
        System.err.println(((Object)((Object)this)).getClass().getName() + ": unhandled attribute type " + attType);
        return false;
    }

    public void setIncludeAttributes(int attType, boolean value) {
        switch (attType) {
            case 0: {
                this.m_CheckBoxIncludeNumericAttributes.setSelected(value);
                break;
            }
            case 3: {
                this.m_CheckBoxIncludeDateAttributes.setSelected(value);
                break;
            }
            case 1: {
                this.m_CheckBoxIncludeNominalAttributes.setSelected(value);
                break;
            }
            case 2: {
                this.m_CheckBoxIncludeStringAttributes.setSelected(value);
                break;
            }
            case 4: {
                this.m_CheckBoxIncludeRelationalAttributes.setSelected(value);
                break;
            }
            default: {
                System.err.println(((Object)((Object)this)).getClass().getName() + ": unhandled attribute type " + attType);
            }
        }
    }

    public boolean getIncludeAttributes(int attType) {
        switch (attType) {
            case 0: {
                return this.m_CheckBoxIncludeNumericAttributes.isSelected();
            }
            case 3: {
                return this.m_CheckBoxIncludeDateAttributes.isSelected();
            }
            case 1: {
                return this.m_CheckBoxIncludeNominalAttributes.isSelected();
            }
            case 2: {
                return this.m_CheckBoxIncludeStringAttributes.isSelected();
            }
            case 4: {
                return this.m_CheckBoxIncludeRelationalAttributes.isSelected();
            }
        }
        System.err.println(((Object)((Object)this)).getClass().getName() + ": unhandled attribute type " + attType);
        return false;
    }

    public String getFilename() {
        return ((File)this.m_FilePanel.getCurrent()).getAbsolutePath();
    }

    protected void loadFile(boolean reload) {
        int oldSortingIndex;
        int oldIDIndex;
        int oldClassIndex;
        if (!((File)this.m_FilePanel.getCurrent()).isFile()) {
            return;
        }
        String oldClass = null;
        if (reload && this.m_Instances != null && (oldClassIndex = this.m_ComboBoxClass.getSelectedIndex() - 1) > -1) {
            oldClass = this.m_Instances.attribute(oldClassIndex).name();
        }
        String oldID = null;
        if (reload && this.m_Instances != null && (oldIDIndex = this.m_ComboBoxID.getSelectedIndex() - 1) > -1) {
            oldID = this.m_Instances.attribute(oldIDIndex).name();
        }
        String oldSorting = null;
        if (reload && this.m_Instances != null && (oldSortingIndex = this.m_ComboBoxSorting.getSelectedIndex() - 1) > -1) {
            oldSorting = this.m_Instances.attribute(oldSortingIndex).name();
        }
        int[] oldAdditional = new int[]{};
        if (reload && this.m_Instances != null) {
            oldAdditional = this.m_ListAdditionalAttributes.getSelectedIndices();
        }
        try {
            if (this.m_FilePanel.getLoader() == null) {
                throw new IllegalStateException("Cannot determine loader for file!");
            }
            this.m_Instances = this.m_FilePanel.getLoader().getDataSet();
            this.m_TextAttributeRange.setToolTipText("#attributes: " + this.m_Instances.numAttributes());
        }
        catch (Exception e) {
            this.m_TextAttributeRange.setToolTipText(null);
            this.m_Instances = null;
            e.printStackTrace();
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Error loading file '" + this.getFilename() + "' - exception:\n" + e));
        }
        if (!reload) {
            this.m_TextAttributeRange.setText(this.m_DefaultAttributeRange.getRange());
        }
        this.m_ComboBoxClassModel.removeAllElements();
        this.m_ComboBoxClassModel.addElement(NO_CLASS);
        this.m_ComboBoxClass.setSelectedIndex(0);
        this.m_ComboBoxIDModel.removeAllElements();
        this.m_ComboBoxIDModel.addElement(NO_ID);
        this.m_ComboBoxID.setSelectedIndex(0);
        this.m_ComboBoxSortingModel.removeAllElements();
        this.m_ComboBoxSortingModel.addElement(NO_SORTING);
        this.m_ComboBoxSorting.setSelectedIndex(0);
        this.m_ListAdditionalAttributesModel.clear();
        if (this.m_Instances != null) {
            oldClassIndex = -1;
            oldIDIndex = -1;
            oldSortingIndex = -1;
            this.m_TableData.setModel((TableModel)((Object)new InstanceTableModel(this.m_Instances)));
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                this.m_ComboBoxClassModel.addElement(i + 1 + ": " + this.m_Instances.attribute(i).name());
                this.m_ComboBoxIDModel.addElement(i + 1 + ": " + this.m_Instances.attribute(i).name());
                this.m_ComboBoxSortingModel.addElement(i + 1 + ": " + this.m_Instances.attribute(i).name());
                this.m_ListAdditionalAttributesModel.addElement(i + 1 + ": " + this.m_Instances.attribute(i).name());
                if (oldClass != null && this.m_Instances.attribute(i).name().equals(oldClass)) {
                    oldClassIndex = i;
                }
                if (oldID != null && this.m_Instances.attribute(i).name().equals(oldID)) {
                    oldIDIndex = i;
                }
                if (oldSorting == null || !this.m_Instances.attribute(i).name().equals(oldSorting)) continue;
                oldSortingIndex = i;
            }
            if (oldClassIndex != -1) {
                this.m_ComboBoxClass.setSelectedIndex(oldClassIndex + 1);
            } else if (!reload && this.m_DefaultClassIndex.hasIndex()) {
                this.m_DefaultClassIndex.setMax(this.m_Instances.numAttributes());
                if (this.m_DefaultClassIndex.getIntIndex() != -1) {
                    this.m_ComboBoxClass.setSelectedIndex(this.m_DefaultClassIndex.getIntIndex() + 1);
                }
            }
            if (oldIDIndex != -1) {
                this.m_ComboBoxID.setSelectedIndex(oldIDIndex + 1);
            } else if (!reload && this.m_DefaultIDIndex.hasIndex()) {
                this.m_DefaultIDIndex.setMax(this.m_Instances.numAttributes());
                if (this.m_DefaultIDIndex.getIntIndex() != -1) {
                    this.m_ComboBoxID.setSelectedIndex(this.m_DefaultIDIndex.getIntIndex() + 1);
                }
            }
            if (!reload) {
                this.m_CheckBoxIncludeNumericAttributes.setSelected(this.m_DefaultIncludeNumericAttributes);
            }
            if (oldSortingIndex != -1) {
                this.m_ComboBoxSorting.setSelectedIndex(oldSortingIndex + 1);
            } else if (!reload && this.m_DefaultSortIndex.hasIndex()) {
                this.m_DefaultSortIndex.setMax(this.m_Instances.numAttributes());
                if (this.m_DefaultSortIndex.getIntIndex() != -1) {
                    this.m_ComboBoxSorting.setSelectedIndex(this.m_DefaultSortIndex.getIntIndex() + 1);
                }
            }
            this.m_ListAdditionalAttributes.setSelectedIndices(oldAdditional);
        } else {
            this.m_ButtonLoad.setEnabled(false);
        }
    }

    protected void acceptSelection() {
        int i;
        int[] indices;
        if (this.m_TableData.getSelectedRowCount() == 0) {
            indices = new int[this.m_Instances.numInstances()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
        } else {
            indices = this.m_TableData.getSelectedRows();
        }
        this.m_Indices = new int[indices.length];
        for (i = 0; i < indices.length; ++i) {
            this.m_Indices[i] = (Integer)this.m_TableData.getValueAt(indices[i], 0) - 1;
        }
        this.setVisible(false);
        if (this.m_AcceptListener != null) {
            this.m_AcceptListener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    protected void search() {
        String search = this.m_SearchPanel.getSearchText().trim();
        if (search.length() == 0) {
            search = null;
        }
        this.m_TableData.search(search, this.m_SearchPanel.isRegularExpression());
        this.m_SearchPanel.grabFocus();
    }

    protected void close() {
        this.m_Indices = null;
        this.setVisible(false);
        if (this.m_CancelListener != null) {
            this.m_CancelListener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    protected void beforeShow() {
        super.beforeShow();
        this.m_Indices = null;
    }

    public void setCurrentDirectory(File value) {
        this.m_FilePanel.setCurrentDirectory(value);
    }

    public File getCurrentDirectory() {
        return this.m_FilePanel.getCurrentDirectory();
    }

    public void setCurrent(File value) {
        this.m_FilePanel.setCurrent(value);
        this.m_TableData.clearSelection();
        this.m_FilePanel.fireCurrentValueChanged();
    }

    public File getCurrent() {
        return (File)this.m_FilePanel.getCurrent();
    }

    public void setAcceptListener(ChangeListener l) {
        this.m_AcceptListener = l;
    }

    public ChangeListener getAcceptListener() {
        return this.m_AcceptListener;
    }

    public void setCancelListener(ChangeListener l) {
        this.m_CancelListener = l;
    }

    public ChangeListener getCancelListener() {
        return this.m_CancelListener;
    }
}

