/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.weka;

import adams.core.Shortening;
import adams.data.weka.ArffUtils;
import adams.env.Environment;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.JTableHelper;
import adams.gui.core.SortableAndSearchableTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import weka.core.Attribute;
import weka.core.Instances;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.visualize.InstanceInfoFrame;

public abstract class AbstractInstanceInfoFrame
extends InstanceInfoFrame {
    private static final long serialVersionUID = 1811456515654254510L;
    protected BaseTabbedPane m_TabbedPane;
    protected BasePanel m_PanelTextAll;
    protected JLabel m_LabelTextNumPoints;
    protected BaseComboBox m_ComboBoxTextInstances;
    protected BaseComboBox m_ComboBoxTextActions;
    protected BaseButton m_ButtonTextGo;
    protected JPanel m_PanelTextAction;
    protected SortableAndSearchableTable m_TableData;
    protected BasePanel m_PanelData;
    protected BaseComboBox m_ComboBoxData;
    protected BasePanel m_PanelComboBoxData;
    protected BaseComboBox m_ComboBoxDataActions;
    protected BaseButton m_ButtonDataGo;
    protected JPanel m_PanelDataAction;

    protected void initGUI() {
        super.initGUI();
        this.setTitle(this.getDialogTitle());
        this.m_TabbedPane = new BaseTabbedPane();
        this.m_PanelTextAll = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelTextAll.add((Component)new BaseScrollPane((Component)this.m_TextInfo), (Object)"Center");
        this.m_TabbedPane.addTab("Text", (Component)this.m_PanelTextAll);
        this.getContentPane().add((Component)this.m_TabbedPane, "Center");
        this.m_PanelData = new BasePanel((LayoutManager)new BorderLayout());
        this.m_TabbedPane.addTab("Table", (Component)this.m_PanelData);
        this.m_TableData = new SortableAndSearchableTable();
        this.m_TableData.setAutoResizeMode(0);
        this.m_TableData.setSelectionMode(0);
        this.m_TableData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractInstanceInfoFrame.this.m_ButtonDataGo.setEnabled(AbstractInstanceInfoFrame.this.m_TableData.getSelectedRowCount() == 1);
            }
        });
        this.m_PanelData.add((Component)new BaseScrollPane((Component)this.m_TableData), (Object)"Center");
        this.m_ComboBoxData = new BaseComboBox();
        this.m_ComboBoxData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractInstanceInfoFrame.this.updateDataTable();
            }
        });
        this.m_PanelComboBoxData = new BasePanel((LayoutManager)new FlowLayout(0));
        this.m_PanelComboBoxData.add((Component)new JLabel("Data"));
        this.m_PanelComboBoxData.add((Component)this.m_ComboBoxData);
        this.m_PanelData.add((Component)this.m_PanelComboBoxData, (Object)"North");
        this.m_PanelDataAction = new JPanel(new FlowLayout(2));
        this.m_PanelData.add((Component)this.m_PanelDataAction, (Object)"South");
        this.m_ComboBoxDataActions = new BaseComboBox((Object[])this.getActions());
        this.m_ComboBoxDataActions.setSelectedIndex(0);
        this.m_PanelDataAction.add((Component)this.m_ComboBoxDataActions);
        this.m_ButtonDataGo = new BaseButton("Go");
        this.m_ButtonDataGo.setMnemonic('G');
        this.m_ButtonDataGo.setEnabled(false);
        this.m_ButtonDataGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractInstanceInfoFrame.this.m_ComboBoxDataActions.getSelectedIndex() == -1) {
                    return;
                }
                Method method = AbstractInstanceInfoFrame.this.getActionMethod((String)AbstractInstanceInfoFrame.this.m_ComboBoxDataActions.getSelectedItem());
                if (method != null) {
                    try {
                        method.invoke((Object)AbstractInstanceInfoFrame.this, AbstractInstanceInfoFrame.this.m_TabbedPane.getSelectedIndex());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    throw new IllegalStateException("Unhandled action '" + AbstractInstanceInfoFrame.this.m_ComboBoxDataActions.getSelectedItem() + "'!");
                }
            }
        });
        this.m_PanelDataAction.add((Component)this.m_ButtonDataGo);
        this.m_PanelTextAction = new JPanel(new FlowLayout(2));
        this.m_PanelTextAll.add((Component)this.m_PanelTextAction, (Object)"South");
        this.m_LabelTextNumPoints = new JLabel();
        this.m_PanelTextAction.add(this.m_LabelTextNumPoints);
        this.m_ComboBoxTextInstances = new BaseComboBox();
        this.m_PanelTextAction.add((Component)this.m_ComboBoxTextInstances);
        this.m_ComboBoxTextActions = new BaseComboBox((Object[])this.getActions());
        this.m_ComboBoxTextActions.setSelectedIndex(0);
        this.m_PanelTextAction.add((Component)this.m_ComboBoxTextActions);
        this.m_ButtonTextGo = new BaseButton("Go");
        this.m_ButtonTextGo.setMnemonic('G');
        this.m_ButtonTextGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractInstanceInfoFrame.this.m_ComboBoxTextActions.getSelectedIndex() == -1) {
                    return;
                }
                Method method = AbstractInstanceInfoFrame.this.getActionMethod((String)AbstractInstanceInfoFrame.this.m_ComboBoxTextActions.getSelectedItem());
                if (method != null) {
                    try {
                        method.invoke((Object)AbstractInstanceInfoFrame.this, AbstractInstanceInfoFrame.this.m_TabbedPane.getSelectedIndex());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    throw new IllegalStateException("Unhandled action '" + AbstractInstanceInfoFrame.this.m_ComboBoxTextActions.getSelectedItem() + "'!");
                }
            }
        });
        this.m_PanelTextAction.add((Component)this.m_ButtonTextGo);
        this.setSize(400, 600);
    }

    protected String getDialogTitle() {
        return Environment.getInstance().getProject() + ": Instance info";
    }

    protected abstract String generateNumPointsLabel(int var1);

    protected abstract String[] getActions();

    protected abstract Method getActionMethod(String var1);

    protected Method locateMethod(String name) {
        Method result = null;
        try {
            result = ((Object)((Object)this)).getClass().getMethod(name, Integer.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected int extractDatabaseID(String idStr) {
        return new Integer(idStr.split(":")[1].trim());
    }

    protected int getDatabaseIDColumnIndex() {
        Attribute att;
        int result = -1;
        if (this.m_ComboBoxData.getSelectedIndex() > -1 && (att = ((Instances)this.m_Data.get(this.m_ComboBoxData.getSelectedIndex())).attribute(ArffUtils.getDBIDName())) != null) {
            result = att.index() + 1;
        }
        return result;
    }

    protected int getSelectedDatabaseID(int tabIndex) {
        int result = -1;
        if (tabIndex == 0) {
            if (this.m_ComboBoxTextInstances.getSelectedIndex() > -1) {
                result = this.extractDatabaseID(this.m_ComboBoxTextInstances.getSelectedItem().toString());
            }
        } else if (tabIndex == 1) {
            int col;
            if (this.m_TableData.getSelectedRow() > -1 && (col = this.getDatabaseIDColumnIndex()) > -1) {
                result = new Double(this.m_TableData.getValueAt(this.m_TableData.getSelectedRow(), col).toString()).intValue();
            }
        } else {
            System.err.println("Unhandled tab index: " + tabIndex);
        }
        return result;
    }

    protected int[] getSelectedDatabaseIDs(int tabIndex) {
        int[] result = new int[]{};
        if (tabIndex == 0) {
            int id = this.getSelectedDatabaseID(tabIndex);
            if (id != -1) {
                result = new int[]{id};
            }
        } else if (tabIndex == 1) {
            int col;
            int[] rows = this.m_TableData.getSelectedRows();
            if (rows.length != 0 && (col = this.getDatabaseIDColumnIndex()) != -1) {
                result = new int[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    result[i] = new Double(this.m_TableData.getValueAt(rows[i], col).toString()).intValue();
                }
            }
        } else {
            System.err.println("Unhandled tab index: " + tabIndex);
        }
        return result;
    }

    protected int[] getAllDatabaseIDs(int tabIndex) {
        int[] result = new int[]{};
        if (tabIndex == 0) {
            result = new int[this.m_ComboBoxTextInstances.getItemCount()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.extractDatabaseID(this.m_ComboBoxTextInstances.getItemAt(i).toString());
            }
        } else if (tabIndex == 1) {
            int col = this.getDatabaseIDColumnIndex();
            if (col != -1) {
                result = new int[this.m_TableData.getRowCount()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = new Double(this.m_TableData.getValueAt(i, col).toString()).intValue();
                }
            }
        } else {
            System.err.println("Unhandled tab index: " + tabIndex);
        }
        return result;
    }

    public void setInfoData(Vector<Instances> data) {
        int i;
        super.setInfoData(data);
        String[] datasets = new String[data.size()];
        for (i = 0; i < data.size(); ++i) {
            datasets[i] = i + 1 + " :" + Shortening.shortenEnd((String)data.get(i).relationName(), (int)30);
        }
        this.m_ComboBoxData.setModel(new DefaultComboBoxModel<String>(datasets));
        this.m_ComboBoxData.setSelectedIndex(0);
        this.m_PanelComboBoxData.setVisible(data.size() > 1);
        this.m_TableData.clearSelection();
        i = this.getDatabaseIDColumnIndex();
        if (i > -1) {
            this.m_TableData.setOptimalColumnWidth(i);
        }
        Vector<String> list = new Vector<String>();
        HashSet<Long> ids = new HashSet<Long>();
        for (i = 0; i < data.size(); ++i) {
            Attribute att = data.get(i).attribute(ArffUtils.getDBIDName());
            if (att == null || !att.isNumeric()) continue;
            for (int n = 0; n < data.get(i).numInstances(); ++n) {
                long id = (long)data.get(i).instance(n).value(att);
                if (ids.contains(id)) continue;
                ids.add(id);
                list.add(i + ": " + id);
            }
        }
        this.m_LabelTextNumPoints.setText(this.generateNumPointsLabel(list.size()));
        this.m_ComboBoxTextInstances.setModel(new DefaultComboBoxModel(list));
        this.m_ComboBoxTextInstances.setEnabled(list.size() > 0);
        this.m_ButtonTextGo.setEnabled(list.size() > 0);
        if (list.size() > 0) {
            this.m_ComboBoxTextInstances.setSelectedIndex(0);
        }
    }

    protected void updateDataTable() {
        DefaultTableModel model = this.m_ComboBoxData.getSelectedIndex() == -1 ? new DefaultTableModel() : new ArffSortedTableModel((Instances)this.m_Data.get(this.m_ComboBoxData.getSelectedIndex()));
        this.m_TableData.setModel((TableModel)model);
        JTableHelper.setOptimalHeaderWidth((JTable)this.m_TableData);
    }
}

