/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.optimise.genetic;

import adams.opt.optimise.genetic.PackDataDef;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;

public class PackData
implements Serializable {
    private static final long serialVersionUID = 5282852389389950782L;
    protected PackDataDef m_pdd;
    protected Hashtable<String, Integer> m_data = new Hashtable();

    public PackData(PackDataDef pdd) {
        this.m_pdd = pdd;
    }

    public String toString() {
        String ret = "";
        for (String name : this.m_data.keySet()) {
            ret = ret + name + ":" + this.get(name) + ":" + this.m_data.get(name) + ":";
            int[] bits = this.getBits(name);
            for (int i = 0; i < bits.length; ++i) {
                ret = ret + bits[i];
            }
            ret = ret + "\n";
        }
        return ret;
    }

    public Set<String> getKeySet() {
        return this.m_data.keySet();
    }

    public void set(String name, double val) {
        PackDataDef.DataInfo di = this.m_pdd.get(name);
        if (di == null) {
            System.err.println("not there:" + name);
        }
        int bits = di.toBits(val);
        this.m_data.put(name, bits);
    }

    public double get(String name) {
        Integer val;
        PackDataDef.DataInfo di = this.m_pdd.get(name);
        if (di == null) {
            System.err.println("not there:" + name);
        }
        if ((val = this.m_data.get(name)) == null) {
            System.err.println("not there:" + name);
            return 0.0;
        }
        return di.fromBits(val);
    }

    public int[] getBits() {
        int[] ret = new int[this.m_pdd.size()];
        int pos = 0;
        for (PackDataDef.DataInfo di : this.m_pdd.m_packed) {
            this.setInt(ret, pos, di.m_bits, this.m_data.get(di.getName()));
            pos += di.m_bits;
        }
        return ret;
    }

    public int[] getBits(String name) {
        PackDataDef.DataInfo di = this.m_pdd.get(name);
        int[] ret = new int[di.m_bits];
        int pos = 0;
        this.setInt(ret, pos, di.m_bits, this.m_data.get(di.getName()));
        return ret;
    }

    public void putBits(int[] bits) {
        if (bits.length != this.m_pdd.size()) {
            System.err.println("Bad size:" + bits.length);
        } else {
            int pos = 0;
            for (PackDataDef.DataInfo di : this.m_pdd.m_packed) {
                this.m_data.put(di.getName(), this.getInt(bits, pos, di.m_bits));
                pos += di.m_bits;
            }
        }
    }

    protected int getInt(int[] weights, int start, int bits) {
        int res = 0;
        for (int i = start; i < start + bits; ++i) {
            res = (res << 1) + weights[i];
        }
        return res;
    }

    protected void setInt(int[] weights, int start, int bits, int num) {
        for (int i = start + bits - 1; i >= start; --i) {
            weights[i] = num & 1;
            num >>= 1;
        }
    }
}

