/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import weka.classifiers.AbstainingClassifier;
import weka.classifiers.lazy.LWLSynchro;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class AbstainingLWL
extends LWLSynchro
implements AbstainingClassifier {
    private static final long serialVersionUID = 2392909523778511111L;
    protected boolean m_CanAbstain = false;

    public String globalInfo() {
        return super.globalInfo() + "\n\nSupports abstaining if the base classifier is able to do that.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        super.buildClassifier(instances);
        this.m_CanAbstain = this.m_ZeroR == null && this.m_Classifier instanceof AbstainingClassifier && ((AbstainingClassifier)this.m_Classifier).canAbstain();
    }

    @Override
    public boolean canAbstain() {
        return this.m_CanAbstain;
    }

    @Override
    public synchronized double getAbstentionClassification(Instance inst) throws Exception {
        if (this.m_CanAbstain) {
            this.build(inst);
            if (this.m_Train.numInstances() == 0) {
                throw new Exception("No training instances!");
            }
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionClassification(inst);
        }
        return Utils.missingValue();
    }

    @Override
    public synchronized double[] getAbstentionDistribution(Instance inst) throws Exception {
        if (this.m_CanAbstain) {
            if (this.m_ZeroR != null) {
                return this.m_ZeroR.distributionForInstance(inst);
            }
            if (this.m_Train.numInstances() == 0) {
                throw new Exception("No training instances!");
            }
            this.build(inst);
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(inst);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append("\nCan abstain: " + this.m_CanAbstain + "\n");
        return result.toString();
    }
}

