/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class AbstainAverageWithClassifierWeights
extends MultipleClassifiersCombiner
implements WeightedInstancesHandler,
AbstainingClassifier {
    static final long serialVersionUID = -1L;
    protected double m_MaxDifference;
    protected double[] m_MaxDifferences;
    protected double[] m_Mins;
    protected double[] m_Maxes;
    protected boolean[] m_IsPercent;
    protected String m_MaxDifferences_string = "";
    protected double[] m_ClassifierWeights;
    protected String m_ClassifierWeights_string = "";

    public String globalInfo() {
        return "Class for combining classifiers. Result is the average of the classifiers.Abstain if the difference between the classifiers is different from the thresholds specified";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tMaximum acceptable difference between classifiers\n\t(default: 10)\n", "E", 1, "-E <String>"));
        result.addElement(new Option("\tWeights for classifiers\n\t(default: 1)\n", "F", 1, "-F <String>"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-E");
        result.add("" + this.getMaxDifference());
        result.add("-F");
        result.add("" + this.getClassifierWeights());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String curropt = Utils.getOption((char)'E', (String[])options);
        if (curropt.length() != 0) {
            this.setMaxDifference(curropt);
        } else {
            this.setMaxDifference("0-100,10");
        }
        curropt = Utils.getOption((char)'F', (String[])options);
        if (curropt.length() != 0) {
            this.setClassifierWeights(curropt);
        } else {
            this.setClassifierWeights("");
        }
        super.setOptions(options);
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enableDependency(Capabilities.Capability.NUMERIC_CLASS);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.parseString(this.getMaxDifference());
        this.parseWeights(this.getClassifierWeights());
        Instances newData = new Instances(data);
        newData.deleteWithMissingClass();
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            this.getClassifier(i).buildClassifier(newData);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.classificationNumericAverage(instance, true);
    }

    protected boolean checkOK(double avgPrediction, double difference) {
        for (int i = 0; i < this.m_MaxDifferences.length; ++i) {
            if (!(avgPrediction >= this.m_Mins[i]) || !(avgPrediction <= this.m_Maxes[i])) continue;
            if (this.m_IsPercent[i]) {
                return difference / avgPrediction <= this.m_MaxDifferences[i];
            }
            return difference <= this.m_MaxDifferences[i];
        }
        return false;
    }

    protected void parseWeights(String input) {
        this.m_ClassifierWeights = new double[this.m_Classifiers.length];
        for (int i = 0; i < this.m_ClassifierWeights.length; ++i) {
            this.m_ClassifierWeights[i] = 1.0;
        }
        if (input == null || input.equals("")) {
            return;
        }
        String[] entries = input.split(",");
        if (entries.length != this.m_ClassifierWeights.length) {
            System.err.println("Weights no formatted correctly");
            return;
        }
        for (int i = 0; i < this.m_ClassifierWeights.length; ++i) {
            this.m_ClassifierWeights[i] = Double.parseDouble(entries[i]);
        }
    }

    protected void parseString(String input) {
        if (input == null) {
            return;
        }
        String[] entries = input.split(";");
        this.m_Mins = new double[entries.length];
        this.m_Maxes = new double[entries.length];
        this.m_MaxDifferences = new double[entries.length];
        this.m_IsPercent = new boolean[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            String[] entry = entries[i].split(",");
            String[] range = entry[0].split("-");
            double val1 = Double.parseDouble(range[0]);
            double val2 = Double.parseDouble(range[1]);
            double diff = Double.MAX_VALUE;
            if (entry[1].matches(".*%")) {
                String d = entry[1].replaceAll("%", "");
                diff = Double.parseDouble(d) / 100.0;
                this.m_IsPercent[i] = true;
            } else {
                diff = Double.parseDouble(entry[1]);
                this.m_IsPercent[i] = false;
            }
            this.m_Mins[i] = Math.min(val1, val2);
            this.m_Maxes[i] = Math.max(val1, val2);
            this.m_MaxDifferences[i] = diff;
        }
    }

    protected String diffToString() {
        String res = "";
        if (this.m_MaxDifferences == null) {
            return "";
        }
        for (int i = 0; i < this.m_MaxDifferences.length; ++i) {
            if (i != 0) {
                res = res + ";";
            }
            res = res + this.m_Mins[i] + "-" + this.m_Maxes[i] + ",";
            res = this.m_IsPercent[i] ? res + this.m_MaxDifferences[i] * 100.0 + "%" : res + this.m_MaxDifferences[i];
        }
        return res;
    }

    protected double classificationNumericAverage(Instance instance, boolean abstain) throws Exception {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        double sum = 0.0;
        double weightsum = 0.0;
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            double pred = this.getClassifier(i).classifyInstance(instance);
            if (pred > max) {
                max = pred;
            }
            if (pred < min) {
                min = pred;
            }
            sum += pred * this.m_ClassifierWeights[i];
            weightsum += this.m_ClassifierWeights[i];
        }
        double result = sum / weightsum;
        if (!abstain) {
            return result;
        }
        double difference = Math.abs(max - min);
        if (!this.checkOK(result, difference)) {
            return Utils.missingValue();
        }
        return result;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "AbstainAverage: No model built yet.";
        }
        String result = "AbstainAverage combines";
        result = result + " the average of these base learners:\n";
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            result = result + '\t' + this.getClassifierSpec(i) + '\n';
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 7930 $");
    }

    public static void main(String[] argv) {
        AbstainAverageWithClassifierWeights.runClassifier((Classifier)new AbstainAverageWithClassifierWeights(), (String[])argv);
    }

    @Override
    public boolean canAbstain() {
        return true;
    }

    @Override
    public double getAbstentionClassification(Instance inst) throws Exception {
        return this.classificationNumericAverage(inst, false);
    }

    @Override
    public double[] getAbstentionDistribution(Instance inst) throws Exception {
        double[] ret = new double[]{this.getAbstentionClassification(inst)};
        return ret;
    }

    public String classifierWeightsTipText() {
        return "Weight to give to each classifier";
    }

    public String getClassifierWeights() {
        return this.m_ClassifierWeights_string;
    }

    public void setClassifierWeights(String s) {
        this.m_ClassifierWeights_string = s;
    }

    public String maxDifferenceTipText() {
        return "Max difference, else abstain.";
    }

    public String getMaxDifference() {
        return this.m_MaxDifferences_string;
    }

    public void setMaxDifference(String s) {
        this.m_MaxDifferences_string = s;
    }
}

