/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.simple;

import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.AbstractSimpleOptionHandler;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CommandlineRunnable;
import weka.core.Instance;
import weka.core.Utils;

public abstract class AbstractSimpleClassifier
extends AbstractSimpleOptionHandler
implements Classifier,
CapabilitiesHandler {
    private static final long serialVersionUID = 2170248971336058726L;

    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        if (dist == null) {
            throw new Exception("Null distribution predicted");
        }
        switch (instance.classAttribute().type()) {
            case 1: {
                double max = 0.0;
                int maxIndex = 0;
                for (int i = 0; i < dist.length; ++i) {
                    if (!(dist[i] > max)) continue;
                    maxIndex = i;
                    max = dist[i];
                }
                if (max > 0.0) {
                    return maxIndex;
                }
                return Utils.missingValue();
            }
            case 0: 
            case 3: {
                return dist[0];
            }
        }
        return Utils.missingValue();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dist = new double[instance.numClasses()];
        switch (instance.classAttribute().type()) {
            case 1: {
                double classification = this.classifyInstance(instance);
                if (Utils.isMissingValue((double)classification)) {
                    return dist;
                }
                dist[(int)classification] = 1.0;
                return dist;
            }
            case 0: 
            case 3: {
                dist[0] = this.classifyInstance(instance);
                return dist;
            }
        }
        return dist;
    }

    public static void runClassifier(Classifier classifier, String[] options) {
        try {
            if (classifier instanceof CommandlineRunnable) {
                ((CommandlineRunnable)classifier).preExecution();
            }
            System.out.println(Evaluation.evaluateModel((Classifier)classifier, (String[])options));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("General options") || e.getMessage() == null) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
        if (classifier instanceof CommandlineRunnable) {
            try {
                ((CommandlineRunnable)classifier).postExecution();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        return result;
    }
}

