/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractHashableInstance
implements Serializable,
Instance {
    private static final long serialVersionUID = -7852430972984310506L;
    protected Integer m_HashCode = null;
    protected Instance m_Data;
    protected boolean m_ExcludeClass;
    protected boolean m_ExcludeWeight;

    protected AbstractHashableInstance(Instance data) {
        this.m_Data = data;
        this.m_ExcludeClass = false;
        this.m_ExcludeWeight = false;
    }

    public Object copy() {
        AbstractHashableInstance result;
        try {
            Constructor<?> constr = this.getClass().getConstructor(Instance.class);
            result = (AbstractHashableInstance)constr.newInstance(this.m_Data);
            result.assign(this);
        }
        catch (Exception e) {
            System.err.println("Failed to create copy of " + this.getClass().getName() + ":");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public Instance copy(double[] values) {
        AbstractHashableInstance result;
        try {
            Constructor<?> constr = this.getClass().getConstructor(Double.TYPE, double[].class);
            result = (AbstractHashableInstance)constr.newInstance(this.weight(), values);
            result.assign(this);
        }
        catch (Exception e) {
            System.err.println("Failed to create copy of " + this.getClass().getName() + ":");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected void assign(AbstractHashableInstance inst) {
        this.setExcludeClass(inst.getExcludeClass());
        this.setExcludeWeight(inst.getExcludeWeight());
    }

    public Attribute attribute(int index) {
        return this.m_Data.attribute(index);
    }

    public Attribute attributeSparse(int indexOfIndex) {
        return this.m_Data.attributeSparse(indexOfIndex);
    }

    public Attribute classAttribute() {
        return this.m_Data.classAttribute();
    }

    public int classIndex() {
        return this.m_Data.classIndex();
    }

    public boolean classIsMissing() {
        return this.m_Data.classIsMissing();
    }

    public double classValue() {
        return this.m_Data.classValue();
    }

    public Instances dataset() {
        return this.m_Data.dataset();
    }

    public void deleteAttributeAt(int position) {
        this.invalidateHashCode();
        this.m_Data.deleteAttributeAt(position);
    }

    public Enumeration enumerateAttributes() {
        return this.m_Data.enumerateAttributes();
    }

    public boolean equalHeaders(Instance inst) {
        return this.equalHeaders(inst);
    }

    public String equalHeadersMsg(Instance inst) {
        return this.m_Data.equalHeadersMsg(inst);
    }

    public boolean hasMissingValue() {
        return this.m_Data.hasMissingValue();
    }

    public int index(int position) {
        return this.index(position);
    }

    public void insertAttributeAt(int position) {
        this.invalidateHashCode();
        this.m_Data.insertAttributeAt(position);
    }

    public boolean isMissing(int attIndex) {
        return this.m_Data.isMissing(attIndex);
    }

    public boolean isMissing(Attribute att) {
        return this.m_Data.isMissing(att);
    }

    public boolean isMissingSparse(int indexOfIndex) {
        return this.m_Data.isMissingSparse(indexOfIndex);
    }

    public Instance mergeInstance(Instance inst) {
        this.invalidateHashCode();
        return this.m_Data.mergeInstance(inst);
    }

    public int numAttributes() {
        return this.m_Data.numAttributes();
    }

    public int numClasses() {
        return this.m_Data.numClasses();
    }

    public int numValues() {
        return this.m_Data.numValues();
    }

    public Instances relationalValue(int attIndex) {
        return this.m_Data.relationalValue(attIndex);
    }

    public Instances relationalValue(Attribute att) {
        return this.m_Data.relationalValue(att);
    }

    public void replaceMissingValues(double[] array) {
        this.invalidateHashCode();
        this.m_Data.replaceMissingValues(array);
    }

    public void setClassMissing() {
        if (!this.m_ExcludeClass) {
            this.invalidateHashCode();
        }
        this.m_Data.setClassMissing();
    }

    public void setClassValue(double value) {
        if (!this.m_ExcludeClass) {
            this.invalidateHashCode();
        }
        this.m_Data.setClassValue(value);
    }

    public void setClassValue(String value) {
        if (!this.m_ExcludeClass) {
            this.invalidateHashCode();
        }
        this.m_Data.setClassValue(value);
    }

    public void setDataset(Instances instances) {
        this.invalidateHashCode();
        this.m_Data.setDataset(instances);
    }

    public void setMissing(int attIndex) {
        this.invalidateHashCode();
        this.m_Data.setMissing(attIndex);
    }

    public void setMissing(Attribute att) {
        this.invalidateHashCode();
        this.m_Data.setMissing(att);
    }

    public void setValue(int attIndex, double value) {
        this.invalidateHashCode();
        this.m_Data.setValue(attIndex, value);
    }

    public void setValue(int attIndex, String value) {
        this.invalidateHashCode();
        this.m_Data.setValue(attIndex, value);
    }

    public void setValue(Attribute att, double value) {
        this.invalidateHashCode();
        this.m_Data.setValue(att, value);
    }

    public void setValue(Attribute att, String value) {
        this.invalidateHashCode();
        this.m_Data.setValue(att, value);
    }

    public void setValueSparse(int indexOfIndex, double value) {
        this.invalidateHashCode();
        this.m_Data.setValueSparse(indexOfIndex, value);
    }

    public void setWeight(double weight) {
        this.invalidateHashCode();
        this.m_Data.setWeight(weight);
    }

    public String stringValue(int attIndex) {
        return this.m_Data.stringValue(attIndex);
    }

    public String stringValue(Attribute att) {
        return this.m_Data.stringValue(att);
    }

    public double[] toDoubleArray() {
        return this.m_Data.toDoubleArray();
    }

    public String toString() {
        return this.m_Data.toString();
    }

    public String toString(int attIndex) {
        return this.m_Data.toString(attIndex);
    }

    public String toString(Attribute att) {
        return this.m_Data.toString(att);
    }

    public String toString(int attIndex, int afterDecimalPoint) {
        return this.m_Data.toString(attIndex, afterDecimalPoint);
    }

    public String toString(Attribute att, int afterDecimalPoint) {
        return this.m_Data.toString(att, afterDecimalPoint);
    }

    public String toStringMaxDecimalDigits(int afterDecimalPoint) {
        return this.m_Data.toStringMaxDecimalDigits(afterDecimalPoint);
    }

    public String toStringNoWeight() {
        return this.m_Data.toStringNoWeight();
    }

    public String toStringNoWeight(int afterDecimalPoint) {
        return this.m_Data.toStringMaxDecimalDigits(afterDecimalPoint);
    }

    public double value(int attIndex) {
        return this.m_Data.value(attIndex);
    }

    public double value(Attribute att) {
        return this.m_Data.value(att);
    }

    public double valueSparse(int indexOfIndex) {
        return this.m_Data.valueSparse(indexOfIndex);
    }

    public double weight() {
        return this.m_Data.weight();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public void setExcludeClass(boolean value) {
        this.invalidateHashCode();
        this.m_ExcludeClass = value;
    }

    public boolean getExcludeClass() {
        return this.m_ExcludeClass;
    }

    public void setExcludeWeight(boolean value) {
        this.invalidateHashCode();
        this.m_ExcludeWeight = value;
    }

    public boolean getExcludeWeight() {
        return this.m_ExcludeWeight;
    }

    protected void invalidateHashCode() {
        this.m_HashCode = null;
    }

    protected abstract int computeHashCode();

    public synchronized int hashCode() {
        if (this.m_HashCode == null) {
            this.m_HashCode = this.computeHashCode();
        }
        return this.m_HashCode;
    }
}

