/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.LinearRegressionJ;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.PerformanceStats;
import weka.filters.unsupervised.attribute.Normalize;

public class WeightedEuclideanDistanceRidge
extends NormalizableDistance
implements Cloneable,
TechnicalInformationHandler {
    private static final long serialVersionUID = -8518647249857218705L;
    protected double[] m_Coefficients = null;
    protected LinearRegressionJ m_LR = new LinearRegressionJ();
    protected Normalize m_norm = null;
    protected double m_Ridge = 1.0E-8;

    public WeightedEuclideanDistanceRidge() {
    }

    public WeightedEuclideanDistanceRidge(Instances data) {
        super(data);
    }

    protected void initialize() {
        super.initialize();
        this.m_LR.setAttributeSelectionMethod(new SelectedTag(1, LinearRegressionJ.TAGS_SELECTION));
        this.m_LR.setEliminateColinearAttributes(false);
        this.m_LR.setRidge(this.getRidge());
        try {
            this.m_LR.buildClassifier(this.m_Data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_Coefficients = this.m_LR.coefficients();
        for (int i = 0; i < this.m_Coefficients.length; ++i) {
        }
    }

    public String globalInfo() {
        return "Implementing Euclidean distance (or similarity) function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Euclidean distance");
        result.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Euclidean_distance");
        return result;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSet ridge parameter (default 1.0e-8).\n", "R", 1, "-R <double>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add("" + this.getRidge());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String ridgeString = Utils.getOption((char)'R', (String[])options);
        if (ridgeString.length() != 0) {
            this.setRidge(new Double(ridgeString));
        } else {
            this.setRidge(1.0E-8);
        }
        super.setOptions(options);
    }

    public String ridgeTipText() {
        return "The value of the Ridge parameter.";
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public void setRidge(double newRidge) {
        this.m_Ridge = newRidge;
    }

    public double distance(Instance first, Instance second) {
        return Math.sqrt(this.distance(this.transform(first), this.transform(second), Double.POSITIVE_INFINITY));
    }

    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return Math.sqrt(this.distance(this.transform(first), this.transform(second), Double.POSITIVE_INFINITY, stats));
    }

    protected double updateDistance(double currDist, double diff) {
        double result = currDist;
        return result += diff * diff;
    }

    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return super.distance(this.transform(first), this.transform(second), cutOffValue, stats);
    }

    protected double difference(int index, double val1, double val2) {
        if (index == this.m_Data.classIndex()) {
            return 0.0;
        }
        return (val1 - val2) * this.m_Coefficients[index];
    }

    public void postProcessDistances(double[] distances) {
        for (int i = 0; i < distances.length; ++i) {
            distances[i] = Math.sqrt(distances[i]);
        }
    }

    public double sqDifference(int index, double val1, double val2) {
        double val = this.difference(index, val1, val2);
        return val * val;
    }

    public double getMiddle(double[] ranges) {
        double middle = ranges[0] + ranges[2] * 0.5;
        return middle;
    }

    protected Instance transform(Instance i) {
        return i;
    }

    public boolean valueIsSmallerEqual(Instance instance, int dim, double value) {
        return instance.value(dim) <= value;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 12763 $");
    }
}

