/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.Reader;
import weka.core.Instances;
import weka.core.converters.ArffLoader;

public class AArffLoader
extends ArffLoader {
    private static final long serialVersionUID = 8739929496992782311L;

    public Instances getStructure() throws IOException {
        if (this.m_structure == null) {
            if (this.m_sourceReader == null) {
                throw new IOException("No source has been specified");
            }
            try {
                this.m_ArffReader = new AArffReader(this.m_sourceReader, 1, this.getRetrieval() == 1);
                this.m_structure = this.m_ArffReader.getStructure();
            }
            catch (Exception ex) {
                throw new IOException("Unable to determine structure as arff (Reason: " + ex.toString() + ").");
            }
        }
        return new Instances(this.m_structure, 0);
    }

    public String getFileDescription() {
        return "Arff data files (safe)";
    }

    public static class AArffReader
    extends ArffLoader.ArffReader {
        public AArffReader(Reader reader) throws IOException {
            super(reader);
            this.setRetainStringValues(true);
        }

        public AArffReader(Reader reader, int capacity) throws IOException {
            super(reader, capacity);
            this.setRetainStringValues(true);
        }

        public AArffReader(Reader reader, int capacity, boolean batch) throws IOException {
            super(reader, capacity, batch);
            this.setRetainStringValues(true);
        }

        public AArffReader(Reader reader, Instances template, int lines) throws IOException {
            super(reader, template, lines, new String[0]);
            this.setRetainStringValues(true);
        }

        public AArffReader(Reader reader, Instances template, int lines, int capacity) throws IOException {
            super(reader, template, lines, capacity, new String[0]);
            this.setRetainStringValues(true);
        }

        public AArffReader(Reader reader, Instances template, int lines, int capacity, boolean batch) throws IOException {
            super(reader, template, lines, capacity, batch, new String[0]);
            this.setRetainStringValues(true);
        }

        public void setRetainStringValues(boolean value) {
            this.m_retainStringValues = value;
        }

        public boolean getRetainStringValues() {
            return this.m_retainStringValues;
        }
    }
}

