/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.base.BaseRegExp;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class OuterProductAnalysis
extends SimpleStreamFilter
implements UnsupervisedFilter,
TechnicalInformationHandler {
    private static final long serialVersionUID = -4180301757935955561L;
    public static final String DEFAULT_REGEXP = "amplitude-.*";
    public static final String DEFAULT_PREFIX = "opa-";
    protected BaseRegExp m_FirstRange = new BaseRegExp("amplitude-.*");
    protected BaseRegExp m_SecondRange = new BaseRegExp("amplitude-.*");
    protected String m_AttributePrefix = "opa-";
    protected int[] m_First;
    protected int[] m_Second;
    protected int[] m_Positions;
    protected int[] m_Types;

    public String globalInfo() {
        return "Performs Outer Product Analysis (OPA).\n\nFor more information, see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.TITLE, "Spectral fusion by Outer Product Analysis (OPA) to improve predictions of soil organic C");
        result.setValue(TechnicalInformation.Field.AUTHOR, "Fabricio S.Terra, Raphael A.Viscarra Rossel, Jose A.M.Dematte");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Geoderma");
        result.setValue(TechnicalInformation.Field.VOLUME, "335");
        result.setValue(TechnicalInformation.Field.PAGES, "35-46");
        result.setValue(TechnicalInformation.Field.YEAR, "2019");
        result.setValue(TechnicalInformation.Field.URL, "https://doi.org/10.1016/j.geoderma.2018.08.005");
        return result;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe first attribute range to use.\n\t(default: amplitude-.*)", "first", 1, "-first <regexp>"));
        result.addElement(new Option("\tThe second attribute range to use.\n\t(default: amplitude-.*)", "second", 1, "-second <regexp>"));
        result.addElement(new Option("\tThe prefix to use for the generated attributes.\n\t(default: opa-)", "prefix", 1, "-prefix <string>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        BaseRegExp regexp = new BaseRegExp();
        String tmpStr = Utils.getOption((String)"first", (String[])options);
        if (!tmpStr.isEmpty() && regexp.isValid(tmpStr)) {
            this.setFirstRange(new BaseRegExp(tmpStr));
        } else {
            this.setFirstRange(new BaseRegExp(DEFAULT_REGEXP));
        }
        tmpStr = Utils.getOption((String)"second", (String[])options);
        if (!tmpStr.isEmpty() && regexp.isValid(tmpStr)) {
            this.setSecondRange(new BaseRegExp(tmpStr));
        } else {
            this.setSecondRange(new BaseRegExp(DEFAULT_REGEXP));
        }
        tmpStr = Utils.getOption((String)"prefix", (String[])options);
        this.setAttributePrefix(tmpStr);
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-first");
        result.add(this.getFirstRange().getValue());
        result.add("-second");
        result.add(this.getSecondRange().getValue());
        result.add("-prefix");
        result.add(this.getAttributePrefix());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setFirstRange(BaseRegExp value) {
        this.m_FirstRange = value;
        this.reset();
    }

    public BaseRegExp getFirstRange() {
        return this.m_FirstRange;
    }

    public String firstRangeTipText() {
        return "The first range of attributes (regular expression on attribute names)";
    }

    public void setSecondRange(BaseRegExp value) {
        this.m_SecondRange = value;
        this.reset();
    }

    public BaseRegExp getSecondRange() {
        return this.m_SecondRange;
    }

    public String secondRangeTipText() {
        return "The second range of attributes (regular expression on attribute names)";
    }

    public void setAttributePrefix(String value) {
        this.m_AttributePrefix = value;
        this.reset();
    }

    public String getAttributePrefix() {
        return this.m_AttributePrefix;
    }

    public String attributePrefixTipText() {
        return "The prefix to use for the generated attributes.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.disableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        TIntArrayList positions = new TIntArrayList();
        TIntArrayList types = new TIntArrayList();
        TIntArrayList first = new TIntArrayList();
        TIntArrayList second = new TIntArrayList();
        int clsIndex = inputFormat.classIndex();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex()) continue;
            String name = inputFormat.attribute(i).name();
            boolean numeric = inputFormat.attribute(i).isNumeric();
            boolean match = false;
            if (numeric && this.m_FirstRange.isMatch(name)) {
                first.add(i);
                match = true;
            }
            if (numeric && this.m_SecondRange.isMatch(name)) {
                second.add(i);
                match = true;
            }
            if (match) continue;
            positions.add(i);
            types.add(inputFormat.attribute(i).type());
            atts.add((Attribute)inputFormat.attribute(i).copy());
        }
        if (first.size() == 0) {
            throw new IllegalStateException("No attribute names of numeric attributes matched the first range expression: " + this.m_FirstRange);
        }
        if (second.size() == 0) {
            throw new IllegalStateException("No attribute names of numeric attributes matched the second range expression: " + this.m_SecondRange);
        }
        for (i = 0; i < first.size() * second.size(); ++i) {
            atts.add(new Attribute(this.m_AttributePrefix + (i + 1)));
        }
        if (clsIndex > -1) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat + "-opa", atts, 0);
        this.m_Positions = positions.toArray();
        this.m_Types = types.toArray();
        this.m_First = first.toArray();
        this.m_Second = second.toArray();
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        Instances header = this.getOutputFormat();
        double[] values = new double[header.numAttributes()];
        Arrays.fill(values, Utils.missingValue());
        block4: for (int i = 0; i < this.m_Positions.length; ++i) {
            switch (this.m_Types[i]) {
                case 0: 
                case 1: 
                case 3: {
                    values[i] = instance.value(this.m_Positions[i]);
                    continue block4;
                }
                case 2: {
                    values[i] = header.attribute(i).addStringValue(instance.stringValue(this.m_Positions[i]));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type at original position " + this.m_Positions[i] + ": " + Attribute.typeToString((int)this.m_Types[i]));
                }
            }
        }
        double[] old = instance.toDoubleArray();
        for (int y = 0; y < this.m_Second.length; ++y) {
            for (int x = 0; x < this.m_First.length; ++x) {
                values[this.m_Positions.length + this.m_First.length * y + x] = old[this.m_First[x]] * old[this.m_Second[y]];
            }
        }
        if (instance.classIndex() > -1) {
            values[values.length - 1] = instance.classValue();
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(header);
        this.copyValues((Instance)result, false, instance.dataset(), this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        OuterProductAnalysis.runFilter((Filter)new OuterProductAnalysis(), (String[])args);
    }
}

