/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.Utils;
import adams.core.base.BaseString;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.Remove;

public class PartitionedMultiFilter2
extends SimpleBatchFilter {
    private static final long serialVersionUID = -6293720886005713120L;
    protected Filter[] m_Filters = new Filter[]{new AllFilter()};
    protected Range[] m_Ranges = new Range[]{new Range("first-last")};
    protected BaseString[] m_Prefixes = new BaseString[]{new BaseString("filtered")};
    protected boolean m_RemoveUnused = false;
    protected int[] m_IndicesUnused = new int[0];
    protected Instances[] m_Processed;

    public String globalInfo() {
        return "A filter that applies filters on subsets of attributes and assembles the output into a new dataset. Attributes that are not covered by any of the ranges can be either retained or removed from the output.\nCustom attribute name prefixes can be supplied, by default 'filtered-' is used.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tA filter to apply (can be specified multiple times).", "F", 1, "-F <classname [options]>"));
        result.addElement(new Option("\tAn attribute range (can be specified multiple times).\n\tFor each filter a range must be supplied. 'first' and 'last'\n\tare valid indices. 'inv(...)' around the range denotes an\n\tinverted range.", "R", 1, "-R <range>"));
        result.addElement(new Option("\tA prefix for the filtered attributes (can be specified multiple times).\t(default: 'filtered')", "P", 1, "-P <prefix>"));
        result.addElement(new Option("\tFlag for leaving unused attributes out of the output, by default\n\tthese are included in the filter output.", "U", 0, "-U"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        this.setRemoveUnused(weka.core.Utils.getFlag((String)"U", (String[])options));
        ArrayList<Object> filters = new ArrayList<Object>();
        while ((tmpStr = weka.core.Utils.getOption((String)"F", (String[])options)).length() != 0) {
            String[] options2 = weka.core.Utils.splitOptions((String)tmpStr);
            String classname = options2[0];
            options2[0] = "";
            filters.add((Filter)weka.core.Utils.forName(Filter.class, (String)classname, (String[])options2));
        }
        if (filters.size() == 0) {
            filters.add(new AllFilter());
        }
        this.setFilters(filters.toArray(new Filter[filters.size()]));
        ArrayList<Range> ranges = new ArrayList<Range>();
        while ((tmpStr = weka.core.Utils.getOption((String)"R", (String[])options)).length() != 0) {
            Range range;
            if (tmpStr.startsWith("inv(") && tmpStr.endsWith(")")) {
                range = new Range(tmpStr.substring(4, tmpStr.length() - 1));
                range.setInvert(true);
            } else {
                range = new Range(tmpStr);
            }
            ranges.add(range);
        }
        if (ranges.size() == 0) {
            for (Object e : filters) {
                ranges.add(new Range("first-last"));
            }
        }
        this.setRanges(ranges.toArray(new Range[filters.size()]));
        ArrayList<BaseString> prefixes = new ArrayList<BaseString>();
        while ((tmpStr = weka.core.Utils.getOption((String)"P", (String[])options)).length() != 0) {
            prefixes.add(new BaseString(tmpStr));
        }
        if (prefixes.size() == 0) {
            for (Object e : filters) {
                prefixes.add(new BaseString("filtered"));
            }
        }
        this.setPrefixes(prefixes.toArray(new BaseString[filters.size()]));
        this.checkDimensions();
        super.setOptions(options);
        weka.core.Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        if (this.getRemoveUnused()) {
            result.add("-U");
        }
        for (i = 0; i < this.getFilters().length; ++i) {
            result.add("-F");
            result.add(this.getFilterSpec(this.getFilter(i)));
        }
        for (i = 0; i < this.getRanges().length; ++i) {
            String tmpStr = this.getRange(i).getRanges();
            if (this.getRange(i).getInvert()) {
                tmpStr = "inv(" + tmpStr + ")";
            }
            result.add("-R");
            result.add(tmpStr);
        }
        for (i = 0; i < this.getFilters().length; ++i) {
            result.add("-P");
            result.add(this.getPrefixes()[i].getValue());
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    protected void checkDimensions() throws Exception {
        if (this.getFilters().length != this.getRanges().length) {
            throw new IllegalArgumentException("Number of filters (= " + this.getFilters().length + ") and ranges (= " + this.getRanges().length + ") don't match!");
        }
        if (this.getFilters().length != this.getPrefixes().length) {
            throw new IllegalArgumentException("Number of filters (= " + this.getFilters().length + ") and prefixes (= " + this.getPrefixes().length + ") don't match!");
        }
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected void testInputFormat(Instances instanceInfo) throws Exception {
        for (int i = 0; i < this.getRanges().length; ++i) {
            Instances inst = new Instances(instanceInfo, 0);
            if (instanceInfo.size() > 0) {
                inst.add((Instance)instanceInfo.get(0).copy());
            }
            Range range = this.getRanges()[i];
            range.setUpper(instanceInfo.numAttributes() - 1);
            Instances subset = this.generateSubset(inst, range);
            this.getFilters()[i].setInputFormat(subset);
        }
    }

    public void setRemoveUnused(boolean value) {
        this.m_RemoveUnused = value;
    }

    public boolean getRemoveUnused() {
        return this.m_RemoveUnused;
    }

    public String removeUnusedTipText() {
        return "If true then unused attributes (ones that are not covered by any of the ranges) will be removed from the output.";
    }

    public void setFilters(Filter[] filters) {
        this.m_Filters = filters;
        this.m_Ranges = (Range[])Utils.adjustArray((Object)this.m_Ranges, (int)this.m_Filters.length, (Object)new Range());
        this.m_Prefixes = (BaseString[])Utils.adjustArray((Object)this.m_Prefixes, (int)this.m_Filters.length, (Object)new BaseString("filtered"));
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The base filters to be used.";
    }

    public Filter getFilter(int index) {
        return this.m_Filters[index];
    }

    protected String getFilterSpec(Filter filter) {
        String result = filter == null ? "" : filter.getClass().getName() + " " + weka.core.Utils.joinOptions((String[])filter.getOptions());
        return result;
    }

    public void setRanges(Range[] Ranges) {
        this.m_Ranges = Ranges;
        this.m_Prefixes = (BaseString[])Utils.adjustArray((Object)this.m_Prefixes, (int)this.m_Ranges.length, (Object)new BaseString("filtered"));
        this.m_Filters = (Filter[])Utils.adjustArray((Object)this.m_Filters, (int)this.m_Filters.length, (Object)new AllFilter());
        this.reset();
    }

    public Range[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The attribute ranges to be used; 'inv(...)' denotes an inverted range.";
    }

    public void setPrefixes(BaseString[] prefixes) {
        this.m_Prefixes = prefixes;
        this.m_Ranges = (Range[])Utils.adjustArray((Object)this.m_Ranges, (int)this.m_Prefixes.length, (Object)new Range());
        this.m_Filters = (Filter[])Utils.adjustArray((Object)this.m_Filters, (int)this.m_Prefixes.length, (Object)new AllFilter());
        this.reset();
    }

    public BaseString[] getPrefixes() {
        return this.m_Prefixes;
    }

    public String prefixesTipText() {
        return "The prefixes to use; uses 'filtered' if empty.";
    }

    public Range getRange(int index) {
        return this.m_Ranges[index];
    }

    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    protected void determineUnusedIndices(Instances data) {
        TIntArrayList indices = new TIntArrayList();
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) continue;
            boolean covered = false;
            for (int n = 0; n < this.getRanges().length; ++n) {
                if (!this.getRanges()[n].isInRange(i)) continue;
                covered = true;
                break;
            }
            if (covered) continue;
            indices.add(i);
        }
        this.m_IndicesUnused = indices.toArray();
        if (this.getDebug()) {
            System.out.println("Unused indices: " + weka.core.Utils.arrayToString((Object)this.m_IndicesUnused));
        }
    }

    protected Instances generateSubset(Instances data, Range range) throws Exception {
        int[] indices = range.getSelection();
        StringBuilder atts = new StringBuilder();
        for (int i = 0; i < indices.length; ++i) {
            if (i > 0) {
                atts.append(",");
            }
            atts.append("" + (indices[i] + 1));
        }
        if (data.classIndex() > -1 && !range.isInRange(data.classIndex())) {
            atts.append("," + (data.classIndex() + 1));
        }
        Remove filter = new Remove();
        filter.setAttributeIndices(atts.toString());
        filter.setInvertSelection(true);
        filter.setInputFormat(data);
        Instances result = Filter.useFilter((Instances)data, (Filter)filter);
        return result;
    }

    protected Instances renameAttributes(Instances data, String prefix) throws Exception {
        int i;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) {
                atts.add((Attribute)data.attribute(i).copy());
                continue;
            }
            atts.add(data.attribute(i).copy(prefix + data.attribute(i).name()));
        }
        Instances result = new Instances(data.relationName(), atts, data.numInstances());
        for (i = 0; i < data.numInstances(); ++i) {
            result.add((Instance)data.instance(i).copy());
        }
        if (data.classIndex() > -1) {
            result.setClassIndex(data.classIndex());
        }
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Instances result;
        if (!this.isFirstBatchDone()) {
            int i;
            this.checkDimensions();
            this.determineUnusedIndices(inputFormat);
            for (i = 0; i < this.m_Ranges.length; ++i) {
                this.m_Ranges[i].setUpper(inputFormat.numAttributes() - 1);
            }
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            this.m_Processed = new Instances[this.getFilters().length];
            for (i = 0; i < this.getFilters().length; ++i) {
                this.m_Processed[i] = this.generateSubset(inputFormat, this.getRange(i));
                this.getFilter(i).setInputFormat(this.m_Processed[i]);
                this.m_Processed[i] = Filter.useFilter((Instances)this.m_Processed[i], (Filter)this.getFilter(i));
                String prefix = this.m_Prefixes[i].getValue();
                if (prefix.trim().isEmpty()) {
                    prefix = "filtered";
                }
                this.m_Processed[i] = this.renameAttributes(this.m_Processed[i], prefix + "-" + i + "-");
                for (int n = 0; n < this.m_Processed[i].numAttributes(); ++n) {
                    if (n == this.m_Processed[i].classIndex()) continue;
                    atts.add((Attribute)this.m_Processed[i].attribute(n).copy());
                }
            }
            if (!this.getRemoveUnused()) {
                for (i = 0; i < this.m_IndicesUnused.length; ++i) {
                    Attribute att = inputFormat.attribute(this.m_IndicesUnused[i]);
                    atts.add(att.copy("unfiltered-" + att.name()));
                }
            }
            if (inputFormat.classIndex() > -1) {
                atts.add((Attribute)inputFormat.classAttribute().copy());
            }
            result = new Instances(inputFormat.relationName(), atts, 0);
            if (inputFormat.classIndex() > -1) {
                result.setClassIndex(result.numAttributes() - 1);
            }
        } else {
            result = this.getOutputFormat();
        }
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        int i;
        Instances[] processed;
        if (this.m_Processed != null) {
            processed = this.m_Processed;
            this.m_Processed = null;
        } else {
            processed = new Instances[this.getFilters().length];
            for (i = 0; i < this.getFilters().length; ++i) {
                processed[i] = this.generateSubset(instances, this.getRange(i));
                if (!this.isFirstBatchDone()) {
                    this.getFilter(i).setInputFormat(processed[i]);
                }
                processed[i] = Filter.useFilter((Instances)processed[i], (Filter)this.getFilter(i));
            }
        }
        Instances result = this.getOutputFormat();
        TIntArrayList errors = new TIntArrayList();
        for (i = 0; i < processed.length; ++i) {
            if (processed[i].numInstances() == instances.numInstances()) continue;
            errors.add(i);
        }
        if (errors.size() > 0) {
            throw new IllegalStateException("The following filter(s) changed the number of instances: " + errors);
        }
        for (i = 0; i < instances.numInstances(); ++i) {
            int n;
            Instance inst = instances.instance(i);
            double[] values = new double[result.numAttributes()];
            int index = 0;
            for (n = 0; n < processed.length; ++n) {
                for (int m = 0; m < processed[n].numAttributes(); ++m) {
                    if (m == processed[n].classIndex()) continue;
                    values[index] = processed[n].instance(i).isMissing(m) ? weka.core.Utils.missingValue() : (result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(processed[n].instance(i).stringValue(m)) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(processed[n].instance(i).relationalValue(m)) : processed[n].instance(i).value(m)));
                    ++index;
                }
            }
            if (!this.getRemoveUnused()) {
                for (n = 0; n < this.m_IndicesUnused.length; ++n) {
                    values[index] = inst.isMissing(this.m_IndicesUnused[n]) ? weka.core.Utils.missingValue() : (result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(inst.stringValue(this.m_IndicesUnused[n])) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(inst.relationalValue(this.m_IndicesUnused[n])) : inst.value(this.m_IndicesUnused[n])));
                    ++index;
                }
            }
            if (instances.classIndex() > -1) {
                index = values.length - 1;
                values[index] = inst.classIsMissing() ? weka.core.Utils.missingValue() : (result.attribute(index).isString() ? (double)result.attribute(index).addStringValue(inst.stringValue(instances.classIndex())) : (result.attribute(index).isRelationValued() ? (double)result.attribute(index).addRelation(inst.relationalValue(instances.classIndex())) : inst.value(instances.classIndex())));
            }
            Object newInst = inst instanceof SparseInstance ? new SparseInstance(instances.instance(i).weight(), values) : new DenseInstance(instances.instance(i).weight(), values);
            result.add((Instance)newInst);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10215 $");
    }

    public static void main(String[] args) {
        PartitionedMultiFilter2.runFilter((Filter)new PartitionedMultiFilter2(), (String[])args);
    }
}

