/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.weka.WekaAttributeRange;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;

public class StringToDate
extends SimpleStreamFilter {
    private static final long serialVersionUID = -183001278236751069L;
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected WekaAttributeRange m_Range = new WekaAttributeRange("first");
    protected TIntSet m_Indices;
    protected String m_Format = "yyyy-MM-dd HH:mm:ss";

    public String globalInfo() {
        return "Parses the selected range of string attributes using the specified format and turns them into date ones.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe attribute range to process.\n\t(default: first)", "R", 1, "-R <range specification>"));
        result.addElement(new Option("\tThe parse format.\n\tSee: https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html\n\t(default: yyyy-MM-dd HH:mm:ss)", "F", 1, "-F <format>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setRange(new WekaAttributeRange(tmpStr));
        } else {
            this.setRange(new WekaAttributeRange("first"));
        }
        tmpStr = Utils.getOption((String)"F", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setFormat(tmpStr);
        } else {
            this.setFormat(DEFAULT_FORMAT);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-R");
        result.add(this.getRange().getRange());
        result.add("-F");
        result.add(this.getFormat());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setRange(WekaAttributeRange value) {
        this.m_Range = value;
        this.reset();
    }

    public WekaAttributeRange getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The range of attributes to process";
    }

    public void setFormat(String value) {
        this.m_Format = value;
        this.reset();
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The parse format to use on the string attribute(s).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected void reset() {
        super.reset();
        this.m_Indices = null;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        try {
            new SimpleDateFormat(this.m_Format);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid date parse format: " + this.m_Format, e);
        }
        this.m_Range.setData(inputFormat);
        this.m_Indices = new TIntHashSet(this.m_Range.getIntIndices());
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            Attribute att = inputFormat.attribute(i);
            if (this.m_Indices.contains(i)) {
                if (!att.isString()) {
                    throw new IllegalStateException("Attribute at #" + (i + 1) + " is not of type string!");
                }
                atts.add(new Attribute(att.name(), this.m_Format));
                continue;
            }
            atts.add((Attribute)att.copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        double[] values = instance.toDoubleArray();
        for (int index : this.m_Indices.toArray()) {
            values[index] = this.outputFormatPeek().attribute(index).parseDate(instance.stringValue(index));
        }
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (this.m_Indices.contains(i) || !instance.attribute(i).isString()) continue;
            String value = instance.stringValue(i);
            values[i] = this.outputFormatPeek().attribute(i).addStringValue(value);
        }
        Instance result = instance.copy(values);
        result.setDataset(this.outputFormatPeek());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        StringToDate.runFilter((Filter)new StringToDate(), (String[])args);
    }
}

