/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.core.Range;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.SavitzkyGolay;

public class KennardStone
extends SimpleBatchFilter {
    private static final long serialVersionUID = 7465262788509209875L;
    protected static String NUMBER_IN_SUBSET = "number-in-subset";
    protected static String PRE_FILTER = "pre-filter";
    protected static String ATT_RANGE = "att-range";
    public static final int DEFAULT_NUMBER_IN_SUBSET = -1;
    public static final Filter DEFAULT_PRE_FILTER = new SavitzkyGolay();
    public static final Range DEFAULT_ATT_RANGE = new Range("first-last");
    protected int m_NumberInSubset = -1;
    protected Filter m_PreFilter = DEFAULT_PRE_FILTER;
    protected Range m_AttRange = DEFAULT_ATT_RANGE;

    public String globalInfo() {
        return "Applies the Kennard-Stone algorithm to the dataset.\nEach row has the pre-filter (eg PLS) applied before performing the search. The rows selected by the algorithm are returned in the original space, however.\nDistance calculation only uses numeric attributes in the defined range.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.numberInSubsetTipText(), "-1", NUMBER_IN_SUBSET);
        WekaOptionUtils.addOption(result, this.preFilterTipText(), (OptionHandler)DEFAULT_PRE_FILTER, PRE_FILTER);
        WekaOptionUtils.addOption(result, this.attRangeTipText(), DEFAULT_ATT_RANGE, ATT_RANGE);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setNumberInSubset(WekaOptionUtils.parse(options, NUMBER_IN_SUBSET, -1));
        this.setPreFilter((Filter)WekaOptionUtils.parse(options, PRE_FILTER, (OptionHandler)DEFAULT_PRE_FILTER));
        this.setAttRange(WekaOptionUtils.parse(options, ATT_RANGE, DEFAULT_ATT_RANGE));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, NUMBER_IN_SUBSET, this.getNumberInSubset());
        WekaOptionUtils.add(result, PRE_FILTER, (OptionHandler)this.getPreFilter());
        WekaOptionUtils.add(result, ATT_RANGE, this.getAttRange());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public void setNumberInSubset(int value) {
        this.m_NumberInSubset = value;
        this.reset();
    }

    public int getNumberInSubset() {
        return this.m_NumberInSubset;
    }

    public String numberInSubsetTipText() {
        return "Number of rows in subset.";
    }

    public void setPreFilter(Filter value) {
        this.m_PreFilter = value;
        this.reset();
    }

    public Filter getPreFilter() {
        return this.m_PreFilter;
    }

    public String preFilterTipText() {
        return "Pre-filter to apply to the data to perform the search on.";
    }

    public void setAttRange(Range value) {
        this.m_AttRange = value;
        this.reset();
    }

    public Range getAttRange() {
        return this.m_AttRange;
    }

    public String attRangeTipText() {
        return "The attribute range to limit distance calculation to (after applying pre-filter).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.m_PreFilter.getCapabilities();
        result.setOwner((CapabilitiesHandler)this);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected double calculateDistance(Instance inst1, Instance inst2) {
        TDoubleArrayList val1 = new TDoubleArrayList();
        TDoubleArrayList val2 = new TDoubleArrayList();
        int[] indices = this.m_AttRange.getIntIndices();
        for (int i = 0; i < indices.length; ++i) {
            if (!inst1.attribute(indices[i]).isNumeric()) continue;
            val1.add(inst1.value(indices[i]));
            val2.add(inst2.value(indices[i]));
        }
        EuclideanDistance dist = new EuclideanDistance();
        double result = dist.compute(val1.toArray(), val2.toArray());
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        int j;
        int i;
        if (this.isFirstBatchDone()) {
            return instances;
        }
        Instances original = new Instances(instances);
        this.m_PreFilter.setInputFormat(instances);
        Instances filtered = Filter.useFilter((Instances)instances, (Filter)this.m_PreFilter);
        this.m_AttRange.setMax(filtered.numAttributes());
        Instances result = new Instances(instances, 0);
        double[][] distances2D = new double[filtered.numInstances()][filtered.numInstances()];
        for (i = 0; i < filtered.numInstances() - 1; ++i) {
            Instance inst1 = filtered.instance(i);
            for (j = i + 1; j < filtered.numInstances(); ++j) {
                Instance inst2 = filtered.instance(j);
                distances2D[i][j] = this.calculateDistance(inst1, inst2);
            }
        }
        TIntArrayList chosen = new TIntArrayList();
        TIntArrayList remaining = new TIntArrayList();
        for (i = 0; i < filtered.numInstances(); ++i) {
            remaining.add(i);
        }
        double maxDistance = -1.0;
        int chosen1 = -1;
        int chosen2 = -1;
        for (i = 0; i < filtered.numInstances() - 1; ++i) {
            for (j = i + 1; j < filtered.numInstances(); ++j) {
                if (!(distances2D[i][j] > maxDistance)) continue;
                maxDistance = distances2D[i][j];
                chosen1 = i;
                chosen2 = j;
            }
        }
        chosen.add(chosen1);
        chosen.add(chosen2);
        remaining.remove(remaining.indexOf(chosen1));
        remaining.remove(remaining.indexOf(chosen2));
        for (int m = 3; m <= this.m_NumberInSubset; ++m) {
            double maxDistanceTest = -1.0;
            int bestIndex = -1;
            for (i = 0; i < remaining.size(); ++i) {
                double lowestDistanceSingle = Double.POSITIVE_INFINITY;
                int indexTest = remaining.get(i);
                for (j = 0; j < chosen.size(); ++j) {
                    int indexExisting = chosen.get(j);
                    double thisDistance = distances2D[Math.min(indexTest, indexExisting)][Math.max(indexTest, indexExisting)];
                    if (!(thisDistance < lowestDistanceSingle)) continue;
                    lowestDistanceSingle = thisDistance;
                }
                if (!(lowestDistanceSingle > maxDistanceTest)) continue;
                maxDistanceTest = lowestDistanceSingle;
                bestIndex = indexTest;
            }
            chosen.add(bestIndex);
            remaining.remove(remaining.indexOf(bestIndex));
        }
        for (i = 0; i < chosen.size(); ++i) {
            result.add(original.instance(chosen.get(i)));
        }
        return result;
    }
}

