/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.core.option.WekaCommandLineHandler;
import adams.data.weka.columnfinder.ByName;
import adams.data.weka.columnfinder.ColumnFinder;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.control.Trigger;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.WekaFileWriter;
import adams.flow.source.FileSupplier;
import adams.flow.source.Start;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.CallableTransformer;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaDatasetsMerge;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.wekadatasetsmerge.AbstractMerge;
import adams.flow.transformer.wekadatasetsmerge.JoinOnID;
import adams.flow.transformer.wekadatasetsmerge.Simple;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.SimpleArffLoader;
import weka.core.converters.SimpleArffSaver;

public class WekaDatasetsMergeTest
extends AbstractFlowTest {
    public WekaDatasetsMergeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("test-input-1.arff");
        this.m_TestHelper.copyResourceToTmp("test-input-2.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("test-input-1.arff");
        this.m_TestHelper.deleteFileFromTmp("test-input-2.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.arff");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile1.arff"), new TmpFile("dumpfile2.arff")});
    }

    public static Test suite() {
        return new TestSuite(WekaDatasetsMergeTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            CallableActors callableactors = new CallableActors();
            ArrayList<ArrayProcess> actors2 = new ArrayList<ArrayProcess>();
            ArrayProcess arrayprocess = new ArrayProcess();
            AbstractArgumentOption argOption = (AbstractArgumentOption)arrayprocess.getOptionManager().findByProperty("name");
            arrayprocess.setName((String)argOption.valueOf("ARFFFilesToDatasets"));
            ArrayList<Object> actors3 = new ArrayList<Object>();
            WekaFileReader wekafilereader = new WekaFileReader();
            SimpleArffLoader simplearffloader = new SimpleArffLoader();
            wekafilereader.setCustomLoader((AbstractFileLoader)simplearffloader);
            actors3.add(wekafilereader);
            WekaClassSelector wekaclassselector = new WekaClassSelector();
            actors3.add(wekaclassselector);
            arrayprocess.setActors(actors3.toArray(new Actor[0]));
            actors2.add(arrayprocess);
            callableactors.setActors(actors2.toArray(new Actor[0]));
            actors.add(callableactors);
            Start start = new Start();
            actors.add(start);
            Trigger trigger = new Trigger();
            argOption = (AbstractArgumentOption)trigger.getOptionManager().findByProperty("name");
            trigger.setName((String)argOption.valueOf("simple-pass"));
            ArrayList<Object> actors4 = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            filesupplier.setOutputArray(true);
            argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/test-input-1.arff"));
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/test-input-2.arff"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors4.add(filesupplier);
            CallableTransformer callabletransformer = new CallableTransformer();
            argOption = (AbstractArgumentOption)callabletransformer.getOptionManager().findByProperty("callableName");
            callabletransformer.setCallableName((CallableActorReference)argOption.valueOf("ARFFFilesToDatasets"));
            actors4.add(callabletransformer);
            WekaDatasetsMerge wekadatasetsmerge = new WekaDatasetsMerge();
            Simple simple = new Simple();
            ByName byName = new ByName();
            byName.setRegExp(new BaseRegExp("^.*class.*$"));
            simple.setClassFinder((ColumnFinder)byName);
            argOption = (AbstractArgumentOption)simple.getOptionManager().findByProperty("datasetNames");
            ArrayList<BaseString> datasetnames = new ArrayList<BaseString>();
            datasetnames.add((BaseString)argOption.valueOf("input1"));
            datasetnames.add((BaseString)argOption.valueOf("input2"));
            simple.setDatasetNames(datasetnames.toArray(new BaseString[0]));
            argOption = (AbstractArgumentOption)simple.getOptionManager().findByProperty("attributeRenamesExp");
            ArrayList<BaseRegExp> attributerenamesexp = new ArrayList<BaseRegExp>();
            attributerenamesexp.add((BaseRegExp)argOption.valueOf(".*"));
            attributerenamesexp.add((BaseRegExp)argOption.valueOf(".*"));
            simple.setAttributeRenamesExp(attributerenamesexp.toArray(new BaseRegExp[0]));
            argOption = (AbstractArgumentOption)simple.getOptionManager().findByProperty("attributeRenamesFormat");
            ArrayList<BaseString> attributerenamesformat = new ArrayList<BaseString>();
            attributerenamesformat.add((BaseString)argOption.valueOf("{DATASET}-$0"));
            attributerenamesformat.add((BaseString)argOption.valueOf("{DATASET}-$0"));
            simple.setAttributeRenamesFormat(attributerenamesformat.toArray(new BaseString[0]));
            wekadatasetsmerge.setMergeMethod((AbstractMerge)simple);
            actors4.add(wekadatasetsmerge);
            WekaFileWriter wekafilewriter = new WekaFileWriter();
            argOption = (AbstractArgumentOption)wekafilewriter.getOptionManager().findByProperty("outputFile");
            wekafilewriter.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile1.arff"));
            SimpleArffSaver simplearffsaver = new SimpleArffSaver();
            WekaCommandLineHandler wekacommandlinehandler = new WekaCommandLineHandler();
            wekacommandlinehandler.setOptions((Object)simplearffsaver, OptionUtils.splitOptions((String)"-decimal 6"));
            wekafilewriter.setCustomSaver((AbstractFileSaver)simplearffsaver);
            actors4.add(wekafilewriter);
            trigger.setActors(actors4.toArray(new Actor[0]));
            actors.add(trigger);
            Trigger trigger2 = new Trigger();
            argOption = (AbstractArgumentOption)trigger2.getOptionManager().findByProperty("name");
            trigger2.setName((String)argOption.valueOf("id-pass"));
            ArrayList<Object> actors5 = new ArrayList<Object>();
            FileSupplier filesupplier2 = new FileSupplier();
            filesupplier2.setOutputArray(true);
            argOption = (AbstractArgumentOption)filesupplier2.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files2 = new ArrayList<PlaceholderFile>();
            files2.add((PlaceholderFile)argOption.valueOf("${TMP}/test-input-1.arff"));
            files2.add((PlaceholderFile)argOption.valueOf("${TMP}/test-input-2.arff"));
            filesupplier2.setFiles(files2.toArray(new PlaceholderFile[0]));
            actors5.add(filesupplier2);
            CallableTransformer callabletransformer2 = new CallableTransformer();
            argOption = (AbstractArgumentOption)callabletransformer2.getOptionManager().findByProperty("callableName");
            callabletransformer2.setCallableName((CallableActorReference)argOption.valueOf("ARFFFilesToDatasets"));
            actors5.add(callabletransformer2);
            WekaDatasetsMerge wekadatasetsmerge2 = new WekaDatasetsMerge();
            JoinOnID joinonid = new JoinOnID();
            byName = new ByName();
            byName.setRegExp(new BaseRegExp("^.*class.*$"));
            joinonid.setClassFinder((ColumnFinder)byName);
            argOption = (AbstractArgumentOption)joinonid.getOptionManager().findByProperty("datasetNames");
            ArrayList<BaseString> datasetnames2 = new ArrayList<BaseString>();
            datasetnames2.add((BaseString)argOption.valueOf("input1"));
            datasetnames2.add((BaseString)argOption.valueOf("input2"));
            joinonid.setDatasetNames(datasetnames2.toArray(new BaseString[0]));
            argOption = (AbstractArgumentOption)joinonid.getOptionManager().findByProperty("attributeRenamesExp");
            ArrayList<BaseRegExp> attributerenamesexp2 = new ArrayList<BaseRegExp>();
            attributerenamesexp2.add((BaseRegExp)argOption.valueOf("^.*$"));
            attributerenamesexp2.add((BaseRegExp)argOption.valueOf("^.*$"));
            joinonid.setAttributeRenamesExp(attributerenamesexp2.toArray(new BaseRegExp[0]));
            argOption = (AbstractArgumentOption)joinonid.getOptionManager().findByProperty("attributeRenamesFormat");
            ArrayList<BaseString> attributerenamesformat2 = new ArrayList<BaseString>();
            attributerenamesformat2.add((BaseString)argOption.valueOf("{DATASET}-$0"));
            attributerenamesformat2.add((BaseString)argOption.valueOf("{DATASET}-$0"));
            joinonid.setAttributeRenamesFormat(attributerenamesformat2.toArray(new BaseString[0]));
            argOption = (AbstractArgumentOption)joinonid.getOptionManager().findByProperty("uniqueID");
            joinonid.setUniqueID((String)argOption.valueOf("id"));
            joinonid.setCompleteRowsOnly(true);
            wekadatasetsmerge2.setMergeMethod((AbstractMerge)joinonid);
            actors5.add(wekadatasetsmerge2);
            WekaFileWriter wekafilewriter2 = new WekaFileWriter();
            argOption = (AbstractArgumentOption)wekafilewriter2.getOptionManager().findByProperty("outputFile");
            wekafilewriter2.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile2.arff"));
            SimpleArffSaver simplearffsaver2 = new SimpleArffSaver();
            WekaCommandLineHandler wekacommandlinehandler2 = new WekaCommandLineHandler();
            wekacommandlinehandler2.setOptions((Object)simplearffsaver2, OptionUtils.splitOptions((String)"-decimal 6"));
            wekafilewriter2.setCustomSaver((AbstractFileSaver)simplearffsaver2);
            actors5.add(wekafilewriter2);
            trigger2.setActors(actors5.toArray(new Actor[0]));
            actors.add(trigger2);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
        }
        catch (Exception e) {
            WekaDatasetsMergeTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaDatasetsMergeTest.runTest((Test)WekaDatasetsMergeTest.suite());
    }
}

