/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.rowfinder;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.ShallowCopySupporter;
import adams.core.classmanager.ClassManager;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.weka.rowfinder.RowFinder;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.Vector;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public abstract class AbstractRowFinderTestCase
extends AdamsTestCase {
    public AbstractRowFinderTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/weka/rowfinder/data");
    }

    protected Instances load(String filename) {
        Instances result;
        try {
            this.m_TestHelper.copyResourceToTmp(filename);
            result = ConverterUtils.DataSource.read((String)(this.m_TestHelper.getTmpDirectory() + "/" + filename));
            this.m_TestHelper.deleteFileFromTmp(filename);
        }
        catch (Exception e) {
            AbstractRowFinderTestCase.fail((String)("Failed to load '" + filename + "': " + filename));
            result = null;
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract RowFinder[] getRegressionSetups();

    protected int[] process(Instances data, RowFinder scheme) {
        return scheme.findRows(data);
    }

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
            result = (String)result + input.substring(index);
        }
        return result;
    }

    protected boolean save(int[] data, String filename) {
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < data.length; ++i) {
            list.add(Integer.toString(data[i]));
        }
        return FileUtils.saveToFile(list, (File)new TmpFile(filename));
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        RowFinder[] setups = this.getRegressionSetups();
        AbstractRowFinderTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            Instances data = this.load(input[i]);
            AbstractRowFinderTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            RowFinder current = setups[i] instanceof ShallowCopySupporter ? (RowFinder)((ShallowCopySupporter)setups[i]).shallowCopy() : (RowFinder)ClassManager.getSingleton().deepCopy((Object)setups[i]);
            AbstractRowFinderTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            int[] processed = this.process(data, current);
            AbstractRowFinderTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractRowFinderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractRowFinderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

