/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.WekaDataGenerator;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.datagenerators.DataGenerator;
import weka.datagenerators.classifiers.classification.Agrawal;

public class WekaDataGeneratorTest
extends AbstractFlowTest {
    public WekaDataGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public Actor getActor() {
        WekaDataGenerator fr = new WekaDataGenerator();
        fr.setDataGenerator((DataGenerator)new Agrawal());
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.arff"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{fr, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(WekaDataGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaDataGeneratorTest.runTest((Test)WekaDataGeneratorTest.suite());
    }
}

