/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.Conversion;
import adams.data.conversion.WekaInstanceToAdamsInstance;
import adams.data.id.AbstractIDGenerator;
import adams.data.id.SimpleIDGenerator;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.IDGenerator;
import adams.flow.transformer.UniqueID;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class UniqueIDTest
extends AbstractFlowTest {
    public UniqueIDTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        Convert ci = new Convert();
        ci.setConversion((Conversion)new WekaInstanceToAdamsInstance());
        UniqueID uid = new UniqueID();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        SimpleIDGenerator simple = new SimpleIDGenerator();
        simple.setFormat("{ID}");
        IDGenerator idg = new IDGenerator();
        idg.setGenerator((AbstractIDGenerator)simple);
        Flow flow = new Flow();
        flow.setActors(new Actor[]{sfs, fr, ci, uid, idg, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(UniqueIDTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        UniqueIDTest.runTest((Test)UniqueIDTest.suite());
    }
}

