/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.padding.PaddingHelper;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.FFT;
import weka.test.AdamsTestHelper;

public class FFTTest
extends AbstractAdamsFilterTest {
    public FFTTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(1);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return new FFT();
    }

    public Filter getFilter(boolean inverse, boolean real) {
        FFT result = new FFT();
        result.setInverseTransform(inverse);
        result.setReal(real);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            FFTTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            FFTTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            FFTTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        int numAtts = icopy.numAttributes();
        if (icopy.classIndex() > -1) {
            --numAtts;
        }
        numAtts = PaddingHelper.nextPowerOf2((int)numAtts);
        if (icopy.classIndex() > -1) {
            ++numAtts;
        }
        FFTTest.assertEquals((int)numAtts, (int)result.numAttributes());
        FFTTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void testNotInverseImaginary() {
        this.m_Filter = this.getFilter(false, false);
        this.testBuffered();
        this.performTest();
    }

    public void testInverseImaginary() {
        this.m_Filter = this.getFilter(true, false);
        this.testBuffered();
        this.performTest();
    }

    public void testNotInverseTrue() {
        this.m_Filter = this.getFilter(false, true);
        this.testBuffered();
        this.performTest();
    }

    public void testInverseReal() {
        this.m_Filter = this.getFilter(true, true);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(FFTTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)FFTTest.suite());
    }
}

