/*
 * Decompiled with CFR 0.152.
 */
package adams.data.binning;

import adams.data.binning.Binnable;
import adams.data.binning.BinnableGroup;
import adams.data.binning.operation.Grouping;
import adams.data.binning.operation.Wrapping;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;

public class BinnableInstances {
    public static List<Binnable<Instance>> toBinnableUsingClass(Instances data) throws Exception {
        return Wrapping.wrap((Collection)data, (Wrapping.BinValueExtractor)new ClassValueBinValueExtractor());
    }

    public static List<Binnable<Instance>> toBinnableUsingIndex(Instances data) throws Exception {
        return Wrapping.wrap((Collection)data, (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
    }

    public static Instances toInstances(List<Binnable<Instance>> list) {
        Instances result = new Instances(((Instance)list.get(0).getPayload()).dataset(), list.size());
        result.addAll((Collection)Wrapping.unwrap(list));
        return result;
    }

    public static class NumericClassGroupExtractor
    implements Grouping.GroupExtractor<Instance>,
    Serializable {
        private static final long serialVersionUID = -2381541290397169468L;

        public String extractGroup(Binnable<Instance> item) {
            return "" + ((Instance)item.getPayload()).classValue();
        }
    }

    public static class StringAttributeGroupExtractor
    implements Grouping.GroupExtractor<Instance>,
    Serializable {
        private static final long serialVersionUID = -2381541290397169468L;
        protected int m_Index;
        protected String m_RegExp;
        protected String m_Group;

        public StringAttributeGroupExtractor(int index, String regExp, String group) {
            this.m_Index = index;
            this.m_RegExp = regExp;
            this.m_Group = group;
        }

        public String extractGroup(Binnable<Instance> item) {
            return ((Instance)item.getPayload()).stringValue(this.m_Index).replaceAll(this.m_RegExp, this.m_Group);
        }
    }

    public static class GroupedClassValueBinValueExtractor
    implements Wrapping.BinValueExtractor<BinnableGroup<Instance>>,
    Serializable {
        private static final long serialVersionUID = -2287393293543008133L;

        public double extractBinValue(BinnableGroup<Instance> object) {
            return ((Instance)((Binnable)object.get().get(0)).getPayload()).classValue();
        }
    }

    public static class ClassValueBinValueExtractor
    implements Wrapping.BinValueExtractor<Instance>,
    Serializable {
        private static final long serialVersionUID = -2287393293543008133L;

        public double extractBinValue(Instance object) {
            return object.classValue();
        }
    }
}

