/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.flow.control.StorageHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Actor;
import java.util.Map;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class MapToWekaInstance
extends AbstractConversion
implements StorageUser {
    private static final long serialVersionUID = 5974871505196882936L;
    protected StorageName m_StorageName;
    protected transient Instances m_Template;

    public String globalInfo() {
        return "Converts a map into a Weka Instance, using the provided storage object (Instances) as template.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored Instances object to use as template.";
    }

    public Class accepts() {
        return Map.class;
    }

    public Class generates() {
        return Instance.class;
    }

    public boolean isUsingStorage() {
        return true;
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"template", (Object)this.m_Template, (String)"template: ");
    }

    protected Object doConvert() throws Exception {
        int i;
        Map map = (Map)this.m_Input;
        if (this.m_Template == null) {
            if (!(this.getOwner() instanceof Actor)) {
                throw new IllegalStateException("Owner does not have access to storage? Must implement " + Utils.classToString(StorageHandler.class) + "!");
            }
            this.m_Template = (Instances)((Actor)this.getOwner()).getStorageHandler().getStorage().get(this.m_StorageName);
            if (this.m_Template == null) {
                throw new IllegalStateException("Failed to obtain Instances template from storage: " + this.m_StorageName);
            }
        }
        double[] values = new double[this.m_Template.numAttributes()];
        for (i = 0; i < values.length; ++i) {
            values[i] = weka.core.Utils.missingValue();
        }
        block7: for (Object keyObj : map.keySet()) {
            Object value = map.get(keyObj);
            if (value == null) continue;
            String key = "" + keyObj;
            Attribute att = this.m_Template.attribute(key);
            if (att != null) {
                switch (att.type()) {
                    case 0: {
                        values[att.index()] = ((Number)value).doubleValue();
                        continue block7;
                    }
                    case 1: {
                        i = att.indexOfValue("" + value);
                        if (i <= -1) continue block7;
                        values[att.index()] = i;
                        continue block7;
                    }
                    case 2: {
                        values[att.index()] = att.addStringValue("" + value);
                        continue block7;
                    }
                    case 3: {
                        values[att.index()] = att.parseDate("" + value);
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((int)att.type()));
            }
            throw new IllegalStateException("Key not an attribute in template: " + key + "\n" + this.m_Template);
        }
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset(this.m_Template);
        return result;
    }
}

