/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Index;
import adams.data.conversion.AbstractConversion;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.CostCurve;
import weka.core.Instances;

public class WekaEvaluationToCostCurve
extends AbstractConversion {
    private static final long serialVersionUID = -3340269698168769770L;
    protected Index m_ClassLabelIndex;

    public String globalInfo() {
        return "Generates cost-curve data from a WEKA Evaluation object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "classLabelIndex", (Object)new Index("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassLabelIndex = new Index("first");
    }

    public void setClassLabelIndex(Index value) {
        this.m_ClassLabelIndex = value;
        this.reset();
    }

    public Index getClassLabelIndex() {
        return this.m_ClassLabelIndex;
    }

    public String classLabelIndexTipText() {
        return "The index of the class label to use for generating the data.";
    }

    public Class accepts() {
        return Evaluation.class;
    }

    public Class generates() {
        return Instances.class;
    }

    protected Object doConvert() throws Exception {
        Evaluation eval = (Evaluation)this.m_Input;
        this.m_ClassLabelIndex.setMax(eval.getHeader().classAttribute().numValues());
        CostCurve curve = new CostCurve();
        Instances cost = curve.getCurve(eval.predictions(), this.m_ClassLabelIndex.getIntIndex());
        return cost;
    }
}

