/*
 * Decompiled with CFR 0.152.
 */
package adams.data.indexedsplits;

import adams.data.indexedsplits.AbstractIndexedSplitsRunsCompatibility;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.MetaData;
import weka.core.Attribute;
import weka.core.Instances;

public class InstancesIndexedSplitsRunsCompatibility
extends AbstractIndexedSplitsRunsCompatibility {
    private static final long serialVersionUID = -5319544776172513377L;

    public String globalInfo() {
        return "Performs compatibility tests between indexed splits configurations and Weka Instances objects.";
    }

    public String lenientTipText() {
        return "If enabled, only the number of instances are used in the compatibility tests.";
    }

    public String isCompatible(Object data, IndexedSplitsRuns runs) {
        int numInst;
        MetaData meta = runs.getMetaData();
        Instances inst = (Instances)data;
        if (meta.containsKey((Object)"dataset.num_instances") && (numInst = meta.getInteger("dataset.num_instances", -1)) > -1 && numInst != inst.numInstances()) {
            return "Number of instances differ (meta-data vs current data): " + numInst + " != " + inst.numInstances();
        }
        if (this.m_Lenient) {
            return null;
        }
        if (meta.containsKey((Object)"dataset.num_attributes")) {
            int numAtts = meta.getInteger("dataset.num_attributes", -1);
            if (numAtts > -1 && numAtts != inst.numAttributes()) {
                return "Number of attributes differ (meta-data vs current data): " + numAtts + " != " + inst.numAttributes();
            }
            for (int i = 0; i < inst.numAttributes(); ++i) {
                String name = "dataset.attribute." + i + ".name";
                String type = "dataset.attribute." + i + ".type";
                if (meta.containsKey((Object)name) && meta.containsKey((Object)type)) {
                    String nameAct = inst.attribute(i).name();
                    String typeAct = Attribute.typeToStringShort((int)inst.attribute(i).type());
                    String nameMeta = meta.getString(name, "");
                    String typeMeta = meta.getString(type, "");
                    if (!nameMeta.equals(nameAct)) {
                        return "Names of attribute #" + i + "differ (meta-data vs current data): " + nameMeta + " != " + nameAct;
                    }
                    if (typeMeta.equals(typeAct)) continue;
                    return "Types of attribute #" + i + "differ (meta-data vs current data): " + typeMeta + " != " + typeAct;
                }
                if (!this.isLoggingEnabled()) continue;
                if (!meta.containsKey((Object)name)) {
                    this.getLogger().info("Missing key in meta-data: " + name);
                }
                if (meta.containsKey((Object)type)) continue;
                this.getLogger().info("Missing key in meta-data: " + type);
            }
        }
        return null;
    }
}

